/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;

public class KeyStoreUtil {
    public static KeyStore createDockerKeyStore(String certPath) throws IOException, GeneralSecurityException {
        PrivateKey privKey = KeyStoreUtil.loadPrivateKey(certPath + "/key.pem");
        Certificate[] certs = KeyStoreUtil.loadCertificates(certPath + "/cert.pem");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        keyStore.setKeyEntry("docker", privKey, "docker".toCharArray(), certs);
        KeyStoreUtil.addCA(keyStore, certPath + "/ca.pem");
        return keyStore;
    }

    public static PrivateKey loadPrivateKey(String keyPath) throws IOException, GeneralSecurityException {
        PEMKeyPair keyPair = KeyStoreUtil.loadPEM(keyPath);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyPair.getPrivateKeyInfo().getEncoded());
        return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
    }

    private static PEMKeyPair loadPEM(String keyPath) throws IOException {
        PEMParser parser = new PEMParser((Reader)new BufferedReader(new FileReader(keyPath)));
        return (PEMKeyPair)parser.readObject();
    }

    private static void addCA(KeyStore keyStore, String caPath) throws KeyStoreException, FileNotFoundException, CertificateException {
        for (Certificate cert : KeyStoreUtil.loadCertificates(caPath)) {
            X509Certificate crt = (X509Certificate)cert;
            String alias = crt.getSubjectX500Principal().getName();
            keyStore.setCertificateEntry(alias, crt);
        }
    }

    private static Certificate[] loadCertificates(String certPath) throws FileNotFoundException, CertificateException {
        FileInputStream is = new FileInputStream(certPath);
        Collection<? extends Certificate> certs = CertificateFactory.getInstance("X509").generateCertificates(is);
        return new ArrayList<Certificate>(certs).toArray(new Certificate[certs.size()]);
    }
}

