/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import io.fabric8.maven.docker.util.ImageName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public final class UrlBuilder {
    private final String apiVersion;
    private final String baseUrl;

    public UrlBuilder(String baseUrl, String apiVersion) {
        this.apiVersion = apiVersion;
        this.baseUrl = this.stripSlash(baseUrl);
    }

    public String buildImage(String image, String dockerfileName, boolean forceRemove, boolean noCache, Map<String, String> buildArgs) {
        Builder urlBuilder = this.u("build", new String[0]).p("t", image).p(forceRemove ? "forcerm" : "rm", true).p("nocache", noCache);
        if (buildArgs != null && !buildArgs.isEmpty()) {
            urlBuilder.p("buildargs", new JSONObject(buildArgs).toString());
        }
        if (dockerfileName != null) {
            urlBuilder.p("dockerfile", dockerfileName);
        }
        return urlBuilder.build();
    }

    public String copyArchive(String containerId, String targetPath) {
        return this.u("containers/%s/archive", containerId).p("path", targetPath).build();
    }

    public String inspectImage(String name) {
        return this.u("images/%s/json", name).build();
    }

    public String containerLogs(String containerId, boolean follow) {
        return this.u("containers/%s/logs", containerId).p("stdout", true).p("stderr", true).p("timestamps", true).p("follow", follow).build();
    }

    public String createContainer(String name) {
        return this.u("containers/create", new String[0]).p("name", name).build();
    }

    public String deleteImage(String name, boolean force) {
        return this.u("images/%s", name).p("force", force).build();
    }

    public String inspectContainer(String containerId) {
        return this.u("containers/%s/json", containerId).build();
    }

    public String listContainers(int limit) {
        return this.u("containers/json", new String[0]).p("limit", limit).build();
    }

    public String pullImage(ImageName name, String registry) {
        return this.u("images/create", new String[0]).p("fromImage", name.getNameWithoutTag(registry)).p("tag", name.getTag()).build();
    }

    public String pushImage(ImageName name, String registry) {
        return this.u("images/%s/push", name.getNameWithoutTag(registry)).p("tag", name.getTag()).p("force", true).build();
    }

    public String removeContainer(String containerId, boolean removeVolumes) {
        return this.u("containers/%s", containerId).p("v", removeVolumes).build();
    }

    public String startContainer(String containerId) {
        return this.u("containers/%s/start", containerId).build();
    }

    public String createExecContainer(String containerId) {
        return this.u("containers/%s/exec", containerId).build();
    }

    public String startExecContainer(String containerId) {
        return this.u("exec/%s/start", containerId).build();
    }

    public String stopContainer(String containerId, int killWait) {
        Builder b = this.u("containers/%s/stop", containerId);
        if (killWait > 0) {
            b.p("t", killWait);
        }
        return b.build();
    }

    public String tagContainer(ImageName source, ImageName target, boolean force) {
        return this.u("images/%s/tag", source.getFullName()).p("repo", target.getNameWithoutTag()).p("tag", target.getTag()).p("force", force).build();
    }

    public String listNetworks() {
        return this.u("networks", new String[0]).build();
    }

    public String createNetwork() {
        return this.u("networks/create", new String[0]).build();
    }

    public String removeNetwork(String id) {
        return this.u("networks/%s", id).build();
    }

    private static String encode(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(param);
        }
    }

    private String stripSlash(String url) {
        String ret = url;
        while (ret.endsWith("/")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private Builder u(String format, String ... args) {
        return new Builder(this.createUrl(String.format(format, this.encodeArgs(args))));
    }

    private String[] encodeArgs(String[] args) {
        String[] ret = new String[args.length];
        int i = 0;
        for (String arg : args) {
            ret[i++] = UrlBuilder.encode(arg);
        }
        return ret;
    }

    private String createUrl(String path) {
        return String.format("%s/%s/%s", this.baseUrl, this.apiVersion, path);
    }

    private static class Builder {
        private Map<String, String> queryParams = new HashMap<String, String>();
        private String url;

        public Builder(String url) {
            this.url = url;
        }

        private Builder p(String key, String value) {
            if (value != null) {
                this.queryParams.put(key, value);
            }
            return this;
        }

        private Builder p(String key, boolean value) {
            return this.p(key, value ? "1" : "0");
        }

        private Builder p(String key, int value) {
            return this.p(key, Integer.toString(value));
        }

        public String build() {
            if (this.queryParams.size() > 0) {
                StringBuilder ret = new StringBuilder(this.url);
                ret.append("?");
                for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
                    ret.append(entry.getKey()).append("=").append(UrlBuilder.encode(entry.getValue())).append("&");
                }
                return ret.substring(0, ret.length() - 1);
            }
            return this.url;
        }
    }
}

