/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.model.Network;
import io.fabric8.maven.docker.util.AutoPullMode;
import io.fabric8.maven.docker.util.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;

public class QueryService {
    private static final int CONTAINER_LIMIT = 100;
    private DockerAccess docker;
    private Logger log;

    public QueryService(DockerAccess docker, Logger log) {
        this.docker = docker;
        this.log = log;
    }

    public Container getContainer(String containerId) throws DockerAccessException {
        return this.docker.inspectContainer(containerId);
    }

    public Container getContainerByName(String containerName) throws DockerAccessException {
        for (Container el : this.docker.listContainers(100)) {
            if (!containerName.equals(el.getName())) continue;
            return el;
        }
        return null;
    }

    public Network getNetworkByName(String networkName) throws DockerAccessException {
        for (Network el : this.docker.listNetworks()) {
            if (!networkName.equals(el.getName())) continue;
            return el;
        }
        return null;
    }

    public Set<Network> getNetworks() throws DockerAccessException {
        return new HashSet<Network>(this.docker.listNetworks());
    }

    public String getContainerName(String containerId) throws DockerAccessException {
        return this.getContainer(containerId).getName();
    }

    public List<Container> getContainersForImage(String image) throws DockerAccessException {
        List<Container> list = this.docker.listContainers(100);
        ArrayList<Container> ret = new ArrayList<Container>();
        for (Container el : list) {
            if (!image.equals(el.getImage())) continue;
            ret.add(el);
        }
        return ret;
    }

    public String getImageId(String imageName) throws DockerAccessException {
        return this.docker.getImageId(imageName);
    }

    public Container getLatestContainerForImage(String image) throws DockerAccessException {
        long newest = 0L;
        Container result = null;
        for (Container container : this.getContainersForImage(image)) {
            long timestamp = container.getCreated();
            if (timestamp < newest) continue;
            newest = timestamp;
            result = container;
        }
        return result;
    }

    public boolean hasContainer(String containerName) throws DockerAccessException {
        return this.getContainerByName(containerName) != null;
    }

    public boolean hasNetwork(String networkName) throws DockerAccessException {
        return this.getNetworkByName(networkName) != null;
    }

    public boolean hasImage(String name) throws DockerAccessException {
        return this.docker.hasImage(name);
    }

    public boolean imageRequiresAutoPull(String mode, String imageName, boolean always) throws DockerAccessException, MojoExecutionException {
        AutoPullMode autoPullMode = AutoPullMode.fromString(mode);
        if (this.pullIfNotPresent(autoPullMode, imageName) || this.alwaysPull(autoPullMode, always)) {
            return true;
        }
        if (!this.hasImage(imageName)) {
            throw new MojoExecutionException(String.format("No image '%s' found, Please enable 'autoPull' or pull image '%s' yourself (docker pull %s)", imageName, imageName, imageName));
        }
        return false;
    }

    private boolean alwaysPull(AutoPullMode autoPullMode, boolean always) {
        return always && autoPullMode == AutoPullMode.ALWAYS;
    }

    private boolean pullIfNotPresent(AutoPullMode autoPull, String name) throws DockerAccessException {
        return autoPull.doPullIfNotPresent() && !this.hasImage(name);
    }
}

