/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.config.ImagePullPolicy;
import io.fabric8.maven.docker.util.AutoPullMode;
import org.json.JSONObject;

public class ImagePullManager {
    private static final String CONTEXT_KEY_PREVIOUSLY_PULLED = "CONTEXT_KEY_PREVIOUSLY_PULLED";
    private final ImagePullPolicy imagePullPolicy;
    private CacheStore cacheStore;

    public ImagePullManager(CacheStore cacheStore, String imagePullPolicy, String autoPull) {
        this.cacheStore = cacheStore;
        this.imagePullPolicy = this.createPullPolicy(imagePullPolicy, autoPull);
    }

    ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public ImagePullPolicy createPullPolicy(String imagePullPolicy, String autoPull) {
        if (imagePullPolicy != null) {
            return ImagePullPolicy.fromString(imagePullPolicy);
        }
        if (autoPull != null) {
            AutoPullMode autoPullMode = AutoPullMode.fromString(autoPull);
            switch (autoPullMode) {
                case OFF: {
                    return ImagePullPolicy.Never;
                }
                case ALWAYS: {
                    return ImagePullPolicy.Always;
                }
                case ON: 
                case ONCE: {
                    return ImagePullPolicy.IfNotPresent;
                }
            }
        }
        return ImagePullPolicy.IfNotPresent;
    }

    public boolean hasAlreadyPulled(String image) {
        return this.load().has(image);
    }

    public void pulled(String image) {
        this.save(this.load().add(image));
    }

    public ImagePullCache load() {
        String pullCacheJson = this.cacheStore.get(CONTEXT_KEY_PREVIOUSLY_PULLED);
        ImagePullCache cache = new ImagePullCache(pullCacheJson);
        if (pullCacheJson == null) {
            this.save(cache);
            this.cacheStore.put(CONTEXT_KEY_PREVIOUSLY_PULLED, cache.toString());
        }
        return cache;
    }

    public void save(ImagePullCache cache) {
        this.cacheStore.put(CONTEXT_KEY_PREVIOUSLY_PULLED, cache.toString());
    }

    class ImagePullCache {
        private JSONObject cache;

        public ImagePullCache() {
            this(null);
        }

        public ImagePullCache(String json) {
            this.cache = json != null ? new JSONObject(json) : new JSONObject();
        }

        public boolean has(String imageName) {
            return this.cache.has(imageName);
        }

        public ImagePullCache add(String image) {
            this.cache.put(image, (Object)Boolean.TRUE);
            return this;
        }

        public String toString() {
            return this.cache.toString();
        }
    }

    public static interface CacheStore {
        public String get(String var1);

        public void put(String var1, String var2);
    }
}

