/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.assembly;

import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;

public class BuildDirs {
    private final String buildTopDir;
    private final MojoParameters params;

    public BuildDirs(String imageName, MojoParameters params) {
        this.params = params;
        this.buildTopDir = imageName != null ? imageName.replace(':', '/') : null;
    }

    public File getOutputDirectory() {
        return this.getDir("build");
    }

    public File getWorkingDirectory() {
        return this.getDir("work");
    }

    public File getTemporaryRootDirectory() {
        return this.getDir("tmp");
    }

    void createDirs() {
        for (String workDir : new String[]{"build", "work", "tmp"}) {
            File dir = this.getDir(workDir);
            if (dir.exists() || dir.mkdirs()) continue;
            throw new IllegalArgumentException("Cannot create directory " + dir.getAbsolutePath());
        }
    }

    private File getDir(String dir) {
        return EnvUtil.prepareAbsoluteOutputDirPath(this.params, this.buildTopDir, dir);
    }
}

