/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.FileUtils;

public class EnvUtil {
    public static final String MAVEN_PROPERTY_REGEXP = "\\s*\\$\\{\\s*([^}]+)\\s*}\\s*$";
    public static final String DOCKER_HTTP_PORT = "2375";
    public static final String PROPERTY_COMBINE_POLICY_SUFFIX = "_combine";
    private static UnaryOperator<String> systemGetEnv = System::getenv;
    private static final Function<String, String[]> SPLIT_ON_LAST_COLON = new Function<String, String[]>(){

        public String[] apply(String element) {
            int colon = element.lastIndexOf(58);
            if (colon < 0) {
                return new String[]{element, element};
            }
            return new String[]{element.substring(0, colon), element.substring(colon + 1)};
        }
    };
    private static final Function<String, Iterable<String>> COMMA_SPLITTER = new Function<String, Iterable<String>>(){
        private Splitter COMMA_SPLIT = Splitter.on((String)",").trimResults().omitEmptyStrings();

        public Iterable<String> apply(String input) {
            return this.COMMA_SPLIT.split((CharSequence)input);
        }
    };
    private static final Predicate<String> NOT_EMPTY = new Predicate<String>(){

        public boolean apply(@Nullable String s) {
            return s != null && !s.isEmpty();
        }
    };
    private static final Function<String, String> TRIM = new Function<String, String>(){

        @Nullable
        public String apply(@Nullable String s) {
            return s != null ? s.trim() : s;
        }
    };

    private EnvUtil() {
    }

    public static String convertTcpToHttpUrl(String connect) {
        String protocol = connect.contains(":2375") ? "http:" : "https:";
        return connect.replaceFirst("^tcp:", protocol);
    }

    public static String extractLargerVersion(String versionA, String versionB) {
        if (versionB == null || versionA == null) {
            return versionA == null ? versionB : versionA;
        }
        String[] partsA = versionA.split("\\.");
        String[] partsB = versionB.split("\\.");
        for (int i = 0; i < (partsA.length < partsB.length ? partsA.length : partsB.length); ++i) {
            int pB;
            int pA = Integer.parseInt(partsA[i]);
            if (pA > (pB = Integer.parseInt(partsB[i]))) {
                return versionA;
            }
            if (pB <= pA) continue;
            return versionB;
        }
        return partsA.length > partsB.length ? versionA : versionB;
    }

    public static boolean greaterOrEqualsVersion(String versionA, String versionB) {
        String largerVersion = EnvUtil.extractLargerVersion(versionA, versionB);
        return largerVersion != null && largerVersion.equals(versionA);
    }

    public static List<String[]> splitOnLastColon(List<String> listToSplit) {
        if (listToSplit != null) {
            return Lists.transform(listToSplit, SPLIT_ON_LAST_COLON);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public static List<String> removeEmptyEntries(@Nullable List<String> input) {
        if (input == null) {
            return Collections.emptyList();
        }
        Iterable trimmedInputs = Iterables.transform(input, TRIM);
        Iterable nonEmptyInputs = Iterables.filter((Iterable)trimmedInputs, NOT_EMPTY);
        return Lists.newArrayList((Iterable)nonEmptyInputs);
    }

    @Nonnull
    public static List<String> splitAtCommasAndTrim(Iterable<String> input) {
        if (input == null) {
            return Collections.emptyList();
        }
        Iterable nonEmptyInputs = Iterables.filter(input, (Predicate)Predicates.notNull());
        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)nonEmptyInputs, COMMA_SPLITTER)));
    }

    public static String[] splitOnSpaceWithEscape(String toSplit) {
        String[] split = toSplit.split("(?<!" + Pattern.quote("\\") + ")\\s+");
        String[] res = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            res[i] = split[i].replaceAll("\\\\ ", " ");
        }
        return res;
    }

    public static String stringJoin(List list, String separator) {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (Object o : list) {
            if (!first) {
                ret.append(separator);
            }
            ret.append(o);
            first = false;
        }
        return ret.toString();
    }

    public static Properties getPropertiesWithSystemOverrides(MavenProject project) {
        Properties properties = new Properties(project.getProperties());
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    public static Map<String, String> extractFromPropertiesAsMap(String prefix, Properties properties) {
        HashMap<String, String> ret = new HashMap<String, String>();
        Enumeration<?> names = properties.propertyNames();
        String prefixP = prefix + ".";
        while (names.hasMoreElements()) {
            String mapKey;
            String propName = (String)names.nextElement();
            if (!EnvUtil.propMatchesPrefix(prefixP, propName) || PROPERTY_COMBINE_POLICY_SUFFIX.equals(mapKey = propName.substring(prefixP.length()))) continue;
            ret.put(mapKey, properties.getProperty(propName));
        }
        return ret.size() > 0 ? ret : null;
    }

    public static List<String> extractFromPropertiesAsList(String prefix, Properties properties) {
        TreeMap<Integer, String> orderedMap = new TreeMap<Integer, String>();
        ArrayList<String> rest = new ArrayList<String>();
        Enumeration<?> names = properties.propertyNames();
        String prefixP = prefix + ".";
        while (names.hasMoreElements()) {
            String index;
            String key = (String)names.nextElement();
            if (!EnvUtil.propMatchesPrefix(prefixP, key) || PROPERTY_COMBINE_POLICY_SUFFIX.equals(index = key.substring(prefixP.length()))) continue;
            String value = properties.getProperty(key);
            try {
                Integer nrIndex = Integer.parseInt(index);
                orderedMap.put(nrIndex, value);
            }
            catch (NumberFormatException exp) {
                rest.add(value);
            }
        }
        ArrayList<String> ret = new ArrayList<String>(orderedMap.values());
        ret.addAll(rest);
        return ret.size() > 0 ? ret : null;
    }

    public static List<Properties> extractFromPropertiesAsListOfProperties(String prefix, Properties properties) {
        String prefixDot = prefix + ".";
        int prefixDotLength = prefixDot.length();
        TreeMap<Integer, Properties> ordered = new TreeMap<Integer, Properties>();
        TreeMap<String, Properties> rest = new TreeMap<String, Properties>();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            Properties entry;
            String propertyKey;
            String key = (String)names.nextElement();
            if (!EnvUtil.propMatchesPrefix(prefixDot, key) || PROPERTY_COMBINE_POLICY_SUFFIX.equals(propertyKey = key.substring(prefixDotLength))) continue;
            int firstDotIndex = propertyKey.indexOf(46);
            String entryName = EnvUtil.getKeyBefore(propertyKey, firstDotIndex);
            String entryPropertyKey = EnvUtil.getKeyAfter(propertyKey, firstDotIndex);
            String entryPropertyValue = properties.getProperty(key);
            try {
                int entryIndex = Integer.parseInt(entryName);
                entry = (Properties)ordered.get(entryIndex);
                if (entry == null) {
                    ordered.put(entryIndex, EnvUtil.newProperties(entryPropertyKey, entryPropertyValue));
                    continue;
                }
                entry.put(entryPropertyKey, entryPropertyValue);
            }
            catch (NumberFormatException ignored) {
                entry = (Properties)rest.get(entryName);
                if (entry == null) {
                    rest.put(entryName, EnvUtil.newProperties(entryPropertyKey, entryPropertyValue));
                    continue;
                }
                entry.put(entryPropertyKey, entryPropertyValue);
            }
        }
        ArrayList<Properties> all = new ArrayList<Properties>(ordered.values());
        all.addAll(rest.values());
        return all.isEmpty() ? null : all;
    }

    private static String getKeyBefore(String name, int separatorIndex) {
        if (separatorIndex == -1) {
            return name;
        }
        return name.substring(0, separatorIndex);
    }

    private static String getKeyAfter(String name, int separatorIndex) {
        if (separatorIndex == -1 || separatorIndex >= name.length()) {
            return "";
        }
        return name.substring(separatorIndex + 1);
    }

    private static Properties newProperties(Object key, Object value) {
        Properties properties = new Properties();
        properties.put(key, value);
        return properties;
    }

    public static String extractMavenPropertyName(String propName) {
        Matcher matcher = Pattern.compile(MAVEN_PROPERTY_REGEXP).matcher(propName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String fixupPath(String path) {
        Pattern pattern = Pattern.compile("^(?i)([A-Z]):(.*)$");
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            String result = "/" + matcher.group(1).toLowerCase() + matcher.group(2);
            return result.replace("\\", "/");
        }
        return path;
    }

    public static String formatDurationTill(long start) {
        long duration = System.currentTimeMillis() - start;
        StringBuilder res = new StringBuilder();
        TimeUnit current = TimeUnit.HOURS;
        while (duration > 0L) {
            long temp = current.convert(duration, TimeUnit.MILLISECONDS);
            if (temp > 0L) {
                duration -= current.toMillis(temp);
                res.append(temp).append(" ").append(current.name().toLowerCase());
                if (temp < 2L) {
                    res.deleteCharAt(res.length() - 1);
                }
                res.append(", ");
            }
            if (current == TimeUnit.SECONDS) break;
            current = TimeUnit.values()[current.ordinal() - 1];
        }
        if (res.lastIndexOf(", ") < 0) {
            return duration + " " + TimeUnit.MILLISECONDS.name().toLowerCase();
        }
        res.deleteCharAt(res.length() - 2);
        int i = res.lastIndexOf(", ");
        if (i > 0) {
            res.deleteCharAt(i);
            res.insert(i, " and");
        }
        return res.toString();
    }

    private static boolean propMatchesPrefix(String prefix, String key) {
        return key.startsWith(prefix) && key.length() >= prefix.length();
    }

    public static String firstRegistryOf(String ... checkFirst) {
        for (String registry : checkFirst) {
            if (registry == null) continue;
            return registry;
        }
        return System.getenv("DOCKER_REGISTRY");
    }

    public static String ensureRegistryHttpUrl(String registry) {
        if (registry.toLowerCase().startsWith("http")) {
            return registry;
        }
        return "https://" + registry;
    }

    public static File prepareAbsoluteOutputDirPath(MojoParameters params, String dir, String path) {
        return EnvUtil.prepareAbsolutePath(params, new File(params.getOutputDirectory(), dir).toString(), path);
    }

    public static File prepareAbsoluteSourceDirPath(MojoParameters params, String path) {
        return EnvUtil.prepareAbsolutePath(params, params.getSourceDirectory(), path);
    }

    private static File prepareAbsolutePath(MojoParameters params, String directory, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        File baseDir = new File(directory);
        if (!baseDir.isAbsolute()) {
            baseDir = new File(params.getProject().getBasedir(), directory);
        }
        return new File(baseDir, path);
    }

    public static void storeTimestamp(File tsFile, Date buildDate) throws MojoExecutionException {
        try {
            File dir;
            if (tsFile.exists()) {
                tsFile.delete();
            }
            if (!(dir = tsFile.getParentFile()).exists() && !dir.mkdirs()) {
                throw new MojoExecutionException("Cannot create directory " + dir);
            }
            FileUtils.fileWrite((File)tsFile, (String)StandardCharsets.US_ASCII.name(), (String)Long.toString(buildDate.getTime()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create " + tsFile + " for storing time " + buildDate.getTime(), (Exception)e);
        }
    }

    public static Date loadTimestamp(File tsFile) throws IOException {
        try {
            if (tsFile.exists()) {
                String ts = FileUtils.fileRead((File)tsFile);
                return new Date(Long.parseLong(ts));
            }
            return null;
        }
        catch (IOException e) {
            throw new IOException("Cannot read timestamp " + tsFile, e);
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static boolean isMaven350OrLater(MavenSession mavenSession) {
        String mavenVersion = mavenSession.getSystemProperties().getProperty("maven.version", "3");
        return EnvUtil.greaterOrEqualsVersion(mavenVersion, "3.5.0");
    }

    public static String getUserHome() {
        String homeDir = (String)systemGetEnv.apply("HOME");
        if (homeDir == null) {
            homeDir = System.getProperty("user.home");
        }
        return homeDir;
    }
}

