/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.config.AttestationConfiguration;
import io.fabric8.maven.docker.util.EnvUtil;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.plugins.annotations.Parameter;

public class BuildXConfiguration
implements Serializable {
    @Parameter
    private String builderName;
    @Parameter
    private String configFile;
    @Parameter
    private String dockerStateDir;
    @Parameter
    private List<String> platforms;
    @Parameter
    private AttestationConfiguration attestations;

    public String getBuilderName() {
        return this.builderName;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getDockerStateDir() {
        return this.dockerStateDir;
    }

    public boolean isBuildX() {
        return !this.getPlatforms().isEmpty();
    }

    @Nonnull
    public List<String> getPlatforms() {
        return EnvUtil.splitAtCommasAndTrim(this.platforms);
    }

    public AttestationConfiguration getAttestations() {
        return this.attestations;
    }

    public static class Builder {
        private final BuildXConfiguration config = new BuildXConfiguration();
        private boolean isEmpty = true;

        public BuildXConfiguration build() {
            return this.isEmpty ? null : this.config;
        }

        public Builder builderName(String builderName) {
            this.config.builderName = builderName;
            if (builderName != null) {
                this.isEmpty = false;
            }
            return this;
        }

        public Builder configFile(String configFile) {
            this.config.configFile = configFile;
            if (configFile != null) {
                this.isEmpty = false;
            }
            return this;
        }

        public Builder dockerStateDir(String dockerStateDir) {
            this.config.dockerStateDir = dockerStateDir;
            if (dockerStateDir != null) {
                this.isEmpty = false;
            }
            return this;
        }

        public Builder platforms(List<String> platforms) {
            this.config.platforms = EnvUtil.removeEmptyEntries(platforms);
            if (!this.config.platforms.isEmpty()) {
                this.isEmpty = false;
            }
            return this;
        }

        public Builder attestations(AttestationConfiguration attestations) {
            this.config.attestations = attestations;
            if (attestations != null) {
                this.isEmpty = false;
            }
            return this;
        }
    }
}

