/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.config.AttestationConfiguration;
import io.fabric8.maven.docker.util.EnvUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.plugins.annotations.Parameter;

public class BuildXConfiguration
implements Serializable {
    @Parameter
    private String builderName;
    @Parameter
    private String configFile;
    @Parameter
    private String dockerStateDir;
    @Parameter
    private List<String> platforms;
    @Parameter
    private AttestationConfiguration attestations;
    @Parameter
    private String nodeName;
    @Parameter
    private String cacheFrom;
    @Parameter
    private String cacheTo;
    @Parameter
    private Map<String, String> driverOpts;

    public String getBuilderName() {
        return this.builderName;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getDockerStateDir() {
        return this.dockerStateDir;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getCacheFrom() {
        return this.cacheFrom;
    }

    public String getCacheTo() {
        return this.cacheTo;
    }

    public boolean isBuildX() {
        return !this.getPlatforms().isEmpty();
    }

    @Nonnull
    public List<String> getPlatforms() {
        return EnvUtil.splitAtCommasAndTrim(this.platforms);
    }

    public AttestationConfiguration getAttestations() {
        return this.attestations;
    }

    public Map<String, String> getDriverOpts() {
        return this.driverOpts;
    }

    public static class Builder {
        private final BuildXConfiguration config = new BuildXConfiguration();
        private boolean isEmpty = true;

        public BuildXConfiguration build() {
            return this.isEmpty ? null : this.config;
        }

        public Builder builderName(String builderName) {
            this.config.builderName = builderName;
            if (builderName != null) {
                this.isEmpty = false;
            }
            return this;
        }

        public Builder nodeName(String nodeName) {
            this.config.nodeName = nodeName;
            if (nodeName != null) {
                this.isEmpty = false;
            }
            return this;
        }

        public Builder configFile(String configFile) {
            this.config.configFile = configFile;
            if (configFile != null) {
                this.isEmpty = false;
            }
            return this;
        }

        public Builder dockerStateDir(String dockerStateDir) {
            this.config.dockerStateDir = dockerStateDir;
            if (dockerStateDir != null) {
                this.isEmpty = false;
            }
            return this;
        }

        public Builder platforms(List<String> platforms) {
            this.config.platforms = EnvUtil.removeEmptyEntries(platforms);
            if (!this.config.platforms.isEmpty()) {
                this.isEmpty = false;
            }
            return this;
        }

        public Builder attestations(AttestationConfiguration attestations) {
            this.config.attestations = attestations;
            if (attestations != null) {
                this.isEmpty = false;
            }
            return this;
        }

        public Builder cacheFrom(String cacheFrom) {
            this.config.cacheFrom = cacheFrom;
            if (cacheFrom != null) {
                this.isEmpty = false;
            }
            return this;
        }

        public Builder driverOpts(Map<String, String> driverOpts) {
            this.config.driverOpts = driverOpts;
            if (driverOpts != null) {
                this.isEmpty = false;
            }
            return this;
        }

        public Builder cacheTo(String cacheTo) {
            this.config.cacheTo = cacheTo;
            if (cacheTo != null) {
                this.isEmpty = false;
            }
            return this;
        }
    }
}

