/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.ExecException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.NetworkConfig;
import io.fabric8.maven.docker.log.LogDispatcher;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.model.Network;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RunService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.ContainerNamingUtil;
import io.fabric8.maven.docker.util.GavLabel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="stop", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class StopMojo
extends AbstractDockerMojo {
    private static final String STOP_NAME_PATTERN_CONFIG = "stopNamePattern";
    @Parameter(property="docker.keepRunning", defaultValue="false")
    private boolean keepRunning;
    @Parameter(property="docker.autoCreateCustomNetworks", defaultValue="false")
    protected boolean autoCreateCustomNetworks;
    @Parameter(property="docker.allContainers", defaultValue="false")
    boolean allContainers;
    @Parameter(property="docker.sledgeHammer", defaultValue="false")
    private boolean sledgeHammer;
    @Parameter(property="docker.containerNamePattern")
    String containerNamePattern = "%n-%i";
    @Parameter(property="docker.stopNamePattern")
    String stopNamePattern;
    @Parameter(property="docker.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="docker.executeStopOnVMShutdown", defaultValue="false")
    private boolean executeStopOnVMShutdown;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (this.executeStopOnVMShutdown) {
            this.executeStopOnVMShutdown = false;
            if (!this.invokedTogetherWithDockerStart()) {
                throw new MojoExecutionException("docker:stop with executeStopOnVMShutdown is only possible if the docker containers started within the same maven session.");
            }
            try {
                Class.forName("org.apache.http.client.methods.HttpDelete", true, this.getClass().getClassLoader());
                Class.forName("com.google.common.base.Strings", true, this.getClass().getClassLoader());
                Class.forName("com.google.common.base.Platform", true, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                this.log.error("Failure in loading org.apache.http.client.methods.HttpDelete class: %s", e.getMessage());
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    super.execute();
                }
                catch (MojoExecutionException | MojoFailureException e) {
                    this.log.error("Failure in stopping container: %s", e.getMessage());
                }
            }));
        } else {
            super.execute();
        }
    }

    @Override
    protected void executeInternal(ServiceHub hub) throws MojoExecutionException, IOException, ExecException {
        if (this.skip) {
            return;
        }
        QueryService queryService = hub.getQueryService();
        RunService runService = hub.getRunService();
        GavLabel gavLabel = this.getGavLabel();
        if (!this.keepRunning) {
            if (this.invokedTogetherWithDockerStart()) {
                runService.stopStartedContainers(this.keepContainer, this.removeVolumes, this.autoCreateCustomNetworks, gavLabel);
            } else {
                this.stopContainers(queryService, runService, gavLabel);
            }
        }
        LogDispatcher dispatcher = this.getLogDispatcher(hub);
        dispatcher.untrackAllContainerLogs();
    }

    private void stopContainers(QueryService queryService, RunService runService, GavLabel gavLabel) throws MojoExecutionException, IOException, ExecException {
        Set<Network> networksToRemove = this.getNetworksToRemove(queryService, gavLabel);
        ArrayList<DockerAccessException> thrownExceptions = new ArrayList<DockerAccessException>();
        for (ImageConfiguration image : this.getResolvedImages()) {
            Collection<Container> existingContainers = this.getContainersForImage(queryService, image);
            for (Container container : existingContainers) {
                if (!this.shouldStopContainer(container, gavLabel)) continue;
                try {
                    runService.stopContainer(container.getId(), image, this.keepContainer, this.removeVolumes);
                }
                catch (DockerAccessException exc) {
                    thrownExceptions.add(exc);
                }
            }
        }
        for (Container container : this.getContainersForMojo(queryService)) {
            if (!this.shouldStopContainer(container, gavLabel)) continue;
            try {
                runService.stopContainer(container.getId(), new ImageConfiguration.Builder().name(container.getImage()).build(), this.keepContainer, this.removeVolumes);
            }
            catch (DockerAccessException exc) {
                thrownExceptions.add(exc);
            }
        }
        try {
            runService.removeCustomNetworks(networksToRemove);
        }
        catch (DockerAccessException exc) {
            thrownExceptions.add(exc);
        }
        if (!thrownExceptions.isEmpty()) {
            DockerAccessException exception = new DockerAccessException("At least one exception thrown during container removal.");
            for (DockerAccessException dae : thrownExceptions) {
                exception.addSuppressed(dae);
            }
            throw exception;
        }
    }

    private Collection<Container> getContainersForMojo(QueryService queryService) throws MojoExecutionException, IOException {
        if (this.stopNamePattern != null) {
            Matcher imageNameMatcher = this.getImageNameMatcher(this.stopNamePattern, STOP_NAME_PATTERN_CONFIG);
            Matcher containerNameMatcher = this.getContainerNameMatcher(this.stopNamePattern, STOP_NAME_PATTERN_CONFIG);
            if (imageNameMatcher == null && containerNameMatcher == null) {
                this.log.warn("There are no image name or container name patterns in non-empty stopNamePattern: no containers will be stopped", new Object[0]);
            } else {
                return this.getContainersForPattern(queryService, !this.keepContainer, imageNameMatcher, containerNameMatcher, STOP_NAME_PATTERN_CONFIG);
            }
        }
        return Collections.emptyList();
    }

    private Collection<Container> getContainersForImage(QueryService queryService, ImageConfiguration image) throws MojoExecutionException, IOException {
        String imageStopNamePattern = image.getStopNamePattern();
        if (imageStopNamePattern != null) {
            Matcher imageNameMatcher = this.getImageNameMatcher(imageStopNamePattern, STOP_NAME_PATTERN_CONFIG);
            Matcher containerNameMatcher = this.getContainerNameMatcher(imageStopNamePattern, STOP_NAME_PATTERN_CONFIG);
            if (imageNameMatcher == null && containerNameMatcher == null) {
                this.log.warn("There are no image name or container name patterns in stopNamePattern for image %s: no containers will be stopped", image.getName());
                return Collections.emptyList();
            }
            return this.getContainersForPattern(queryService, !this.keepContainer, imageNameMatcher, containerNameMatcher, STOP_NAME_PATTERN_CONFIG);
        }
        return ContainerNamingUtil.getContainersToStop(image, this.containerNamePattern, this.getBuildTimestamp(), queryService.getContainersForImage(image.getName(), !this.keepContainer));
    }

    private boolean shouldStopContainer(Container container, GavLabel gavLabel) {
        if (this.isStopAllContainers()) {
            return true;
        }
        String key = gavLabel.getKey();
        Map<String, String> labels = container.getLabels();
        return labels.containsKey(key) && gavLabel.equals(new GavLabel(labels.get(key)));
    }

    private boolean isStopAllContainers() {
        return this.allContainers || this.sledgeHammer;
    }

    private Set<Network> getNetworksToRemove(QueryService queryService, GavLabel gavLabel) throws IOException {
        if (!this.autoCreateCustomNetworks) {
            return Collections.emptySet();
        }
        HashSet<Network> customNetworks = new HashSet<Network>();
        Set<Network> networks = queryService.getNetworks();
        for (ImageConfiguration image : this.getResolvedImages()) {
            Network network;
            NetworkConfig config = image.getRunConfiguration().getNetworkingConfig();
            if (!config.isCustomNetwork() || config.getName() == null || (network = this.getNetworkByName(networks, config.getCustomNetwork())) == null) continue;
            customNetworks.add(network);
            Collection<Container> existingContainers = ContainerNamingUtil.getContainersToStop(image, this.containerNamePattern, this.getBuildTimestamp(), queryService.getContainersForImage(image.getName(), !this.keepContainer));
            for (Container container : existingContainers) {
                if (this.shouldStopContainer(container, gavLabel)) continue;
                customNetworks.remove(network);
            }
        }
        return customNetworks;
    }

    private Network getNetworkByName(Set<Network> networks, String networkName) {
        for (Network network : networks) {
            if (!networkName.equals(network.getName())) continue;
            return network;
        }
        return null;
    }
}

