/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.config;

import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.maven.core.config.VolumeConfiguration;
import java.util.HashMap;
import java.util.Map;

public enum VolumeType {
    HOST_PATH("hostPath"){

        @Override
        public Volume fromConfig(VolumeConfiguration config) {
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewHostPath(config.getPath())).build();
        }
    }
    ,
    EMPTY_DIR("emptyDir"){

        @Override
        public Volume fromConfig(VolumeConfiguration config) {
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewEmptyDir(config.getMedium())).build();
        }
    }
    ,
    GIT_REPO("gitRepo"){

        @Override
        public Volume fromConfig(VolumeConfiguration config) {
            String repository = config.getRepository();
            String revision = config.getRevision();
            return ((VolumeBuilder)((VolumeFluent.GitRepoNested)((VolumeFluent.GitRepoNested)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewGitRepo().withRepository(repository)).withRevision(revision)).endGitRepo()).build();
        }
    }
    ,
    SECRET("secret"){

        @Override
        public Volume fromConfig(VolumeConfiguration config) {
            String secretName = config.getSecretName();
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewSecret(secretName)).build();
        }
    }
    ,
    NFS_PATH("nfsPath"){

        @Override
        public Volume fromConfig(VolumeConfiguration config) {
            String path = config.getPath();
            String server = config.getServer();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewNfs(path, readOnly, server)).build();
        }
    }
    ,
    CGE_DISK("gcePdName"){

        @Override
        public Volume fromConfig(VolumeConfiguration config) {
            String pdName = config.getPdName();
            String fsType = config.getFsType();
            Integer partition = config.getPartition();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewGcePersistentDisk(fsType, partition, pdName, readOnly)).build();
        }
    }
    ,
    GLUSTER_FS_PATH("glusterFsPath"){

        @Override
        public Volume fromConfig(VolumeConfiguration config) {
            String path = config.getPath();
            String endpoints = config.getEndpoints();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewGlusterfs(path, endpoints, readOnly)).build();
        }
    }
    ,
    PERSISTENT_VOLUME_CLAIM("persistentVolumeClaim"){

        @Override
        public Volume fromConfig(VolumeConfiguration config) {
            String claimRef = config.getClaimRef();
            Boolean readOnly = config.getReadOnly();
            return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(config.getName())).withNewPersistentVolumeClaim(claimRef, readOnly)).build();
        }
    };

    private final String type;
    private static final Map<String, VolumeType> VOLUME_TYPES;

    public abstract Volume fromConfig(VolumeConfiguration var1);

    private VolumeType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static VolumeType typeFor(String type) {
        return VOLUME_TYPES.get(type);
    }

    static {
        VOLUME_TYPES = new HashMap<String, VolumeType>();
        for (VolumeType volumeType : VolumeType.values()) {
            VOLUME_TYPES.put(volumeType.getType(), volumeType);
        }
    }
}

