/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.extenvvar;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.fabric8.maven.core.extenvvar.JsonSchema;
import io.fabric8.maven.core.extenvvar.JsonSchemaProperty;
import io.fabric8.maven.core.util.MavenUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.project.MavenProject;

public class ExternalEnvVarHandler {
    public static final String ENVIRONMENT_SCHEMA_FILE = "io/fabric8/environment/schema.json";
    private static ObjectMapper objectMapper = ExternalEnvVarHandler.createObjectMapper();

    public static Map<String, String> getExportedEnvironmentVariables(MavenProject project, Map<String, String> envVars) {
        Map<String, String> ret = ExternalEnvVarHandler.getEnvironmentVarsFromJsonSchema(project, envVars);
        ret.putAll(envVars);
        return ret;
    }

    private static Map<String, String> getEnvironmentVarsFromJsonSchema(MavenProject project, Map<String, String> envVars) {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        JsonSchema schema = ExternalEnvVarHandler.getEnvironmentVariableJsonSchema(project, envVars);
        Map<String, JsonSchemaProperty> properties = schema.getProperties();
        Set<Map.Entry<String, JsonSchemaProperty>> entries = properties.entrySet();
        for (Map.Entry<String, JsonSchemaProperty> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue().getDefaultValue();
            ret.put(name, value != null ? value : "");
        }
        return ret;
    }

    private static JsonSchema getEnvironmentVariableJsonSchema(MavenProject project, Map<String, String> envVars) {
        try {
            JsonSchema schema = ExternalEnvVarHandler.loadEnvironmentSchemas(MavenUtil.getCompileClassLoader(project), project.getBuild().getOutputDirectory());
            if (schema == null) {
                schema = new JsonSchema();
            }
            ExternalEnvVarHandler.addEnvironmentVariables(schema, envVars);
            return schema;
        }
        catch (IOException exp) {
            throw new IllegalArgumentException("Cannot load environment variables from JSON schema", exp);
        }
    }

    private static JsonSchema loadEnvironmentSchemas(ClassLoader classLoader, String ... folderPaths) throws IOException {
        JsonSchema answer = null;
        Enumeration<URL> resources = classLoader.getResources(ENVIRONMENT_SCHEMA_FILE);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            JsonSchema schema = ExternalEnvVarHandler.loadSchema(url);
            answer = ExternalEnvVarHandler.combineSchemas(answer, schema);
        }
        for (String folderPath : folderPaths) {
            File file = new File(folderPath, ENVIRONMENT_SCHEMA_FILE);
            if (!file.isFile()) continue;
            JsonSchema schema = ExternalEnvVarHandler.loadSchema(file);
            answer = ExternalEnvVarHandler.combineSchemas(answer, schema);
        }
        return answer;
    }

    private static void addEnvironmentVariables(JsonSchema schema, Map<String, String> environmentVariables) {
        Map<String, JsonSchemaProperty> properties = schema.getProperties();
        if (properties == null) {
            properties = new HashMap<String, JsonSchemaProperty>();
            schema.setProperties(properties);
        }
        Set<Map.Entry<String, String>> entries = environmentVariables.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            JsonSchemaProperty property = properties.get(name);
            if (property == null) {
                property = new JsonSchemaProperty();
                properties.put(name, property);
            }
            property.setDefaultValue(value);
        }
    }

    private static JsonSchema combineSchemas(JsonSchema schema1, JsonSchema schema2) {
        if (schema1 == null) {
            return schema2;
        }
        if (schema2 != null) {
            Map<String, JsonSchemaProperty> properties2 = schema2.getProperties();
            Map<String, JsonSchemaProperty> properties1 = schema1.getProperties();
            if (properties2 != null) {
                if (properties1 == null) {
                    return schema2;
                }
                properties1.putAll(properties2);
            }
        }
        return schema1;
    }

    private static JsonSchema loadSchema(URL url) throws IOException {
        return (JsonSchema)objectMapper.readerFor(JsonSchema.class).readValue(url);
    }

    private static JsonSchema loadSchema(File file) throws IOException {
        return (JsonSchema)objectMapper.readerFor(JsonSchema.class).readValue(file);
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper;
    }
}

