/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.model.EditableServicePort;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.maven.core.config.ServiceConfiguration;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ServiceHandler {
    public Service getService(ServiceConfiguration service, Map<String, String> annotations) {
        List<Service> ret = this.getServices(Collections.singletonList(service), annotations);
        return ret.size() > 0 ? ret.get(0) : null;
    }

    public List<Service> getServices(List<ServiceConfiguration> services, Map<String, String> annotations) {
        ArrayList<Service> ret = new ArrayList<Service>();
        for (ServiceConfiguration service : services) {
            ServiceBuilder serviceBuilder = (ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(service.getName())).withAnnotations(annotations)).endMetadata();
            ServiceFluent.SpecNested serviceSpecBuilder = serviceBuilder.withNewSpec();
            ArrayList<EditableServicePort> servicePorts = new ArrayList<EditableServicePort>();
            for (ServiceConfiguration.Port port : service.getPorts()) {
                EditableServicePort servicePort = ((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(port.getName())).withProtocol(port.getProtocol().name())).withTargetPort(new IntOrString(Integer.valueOf(port.getTargetPort())))).withPort(Integer.valueOf(port.getPort()))).withNodePort(port.getNodePort())).build();
                servicePorts.add(servicePort);
            }
            if (!servicePorts.isEmpty()) {
                serviceSpecBuilder.withPorts(servicePorts);
            }
            if (service.isHeadless()) {
                serviceSpecBuilder.withClusterIP("None");
            }
            if (!Strings.isNullOrBlank((String)service.getType())) {
                serviceSpecBuilder.withType(service.getType());
            }
            serviceSpecBuilder.endSpec();
            if (!service.isHeadless() && servicePorts.isEmpty()) continue;
            ret.add((Service)serviceBuilder.build());
        }
        return ret;
    }
}

