/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.utils.Files;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.shared.utils.StringUtils;

public class KubernetesResourceUtil {
    public static final String API_VERSION = "v1";
    public static final String API_EXTENSIONS_VERSION = "extensions/v1beta1";
    private static final Map<String, String> FILENAME_TO_KIND_MAPPER = new HashMap<String, String>();
    private static final Map<String, String> KIND_TO_FILENAME_MAPPER = new HashMap<String, String>();
    private static String[] mappings = new String[]{"cm", "ConfigMap", "configmap", "ConfigMap", "deployment", "Deployment", "dc", "DeploymentConfig", "deploymentconfig", "DeploymentConfig", "service", "Service", "svc", "Service", "sa", "ServiceAccount", "rc", "ReplicationController", "rs", "ReplicaSet"};
    private static final String FILENAME_PATTERN = "^(.*?)(-([^-]+))?\\.(yaml|yml|json)$";

    public static KubernetesListBuilder readResourceFragmentsFrom(String apiVersion, String apiExtensionsVersion, File[] resourceFiles) throws IOException {
        KubernetesListBuilder k8sBuilder = new KubernetesListBuilder();
        if (resourceFiles != null) {
            for (File file : resourceFiles) {
                HasMetadata resource = KubernetesResourceUtil.getKubernetesResource(apiVersion, apiExtensionsVersion, file);
                k8sBuilder.withItems(new HasMetadata[]{resource});
            }
        }
        return k8sBuilder;
    }

    public static HasMetadata getKubernetesResource(String defaultApiVersion, String apiExtensionsVersion, File file) throws IOException {
        Map<String, Object> fragment = KubernetesResourceUtil.readAndEnrichFragment(defaultApiVersion, apiExtensionsVersion, file);
        ObjectMapper mapper = new ObjectMapper();
        return (HasMetadata)mapper.convertValue(fragment, HasMetadata.class);
    }

    public static String toYaml(Object resource) throws JsonProcessingException {
        return KubernetesResourceUtil.serializeAsString(resource, ResourceFileType.yaml);
    }

    public static String toJson(Object resource) throws JsonProcessingException {
        return KubernetesResourceUtil.serializeAsString(resource, ResourceFileType.json);
    }

    public static File writeResource(Object resource, File target, ResourceFileType resourceFileType) throws IOException {
        String serialized = KubernetesResourceUtil.serializeAsString(resource, resourceFileType);
        File outputFile = resourceFileType.addExtension(target);
        Files.writeToFile((File)outputFile, (String)serialized, (Charset)Charset.defaultCharset());
        return outputFile;
    }

    private static String serializeAsString(Object resource, ResourceFileType resourceFileType) throws JsonProcessingException {
        ObjectMapper mapper = resourceFileType.getObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS).disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        return mapper.writeValueAsString(resource);
    }

    public static File[] listResourceFragments(File resourceDir) {
        final Pattern filenamePattern = Pattern.compile(FILENAME_PATTERN);
        return resourceDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return filenamePattern.matcher(name).matches();
            }
        });
    }

    private static Map<String, Object> readAndEnrichFragment(String defaultApiVersion, String apiExtensionsVersion, File file) throws IOException {
        String kind;
        Pattern pattern = Pattern.compile(FILENAME_PATTERN, 2);
        Matcher matcher = pattern.matcher(file.getName());
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Resource file name '%s' does not match pattern <name>-<type>.(yaml|yml|json)", file.getName()));
        }
        String name = matcher.group(1);
        String type = matcher.group(3);
        String ext = matcher.group(4).toLowerCase();
        Map<String, Object> fragment = KubernetesResourceUtil.readFragment(file, ext);
        if (type != null) {
            kind = KubernetesResourceUtil.getAndValidateKindFromType(file, type);
        } else {
            kind = FILENAME_TO_KIND_MAPPER.get(name.toLowerCase());
            if (kind != null) {
                name = null;
            }
        }
        KubernetesResourceUtil.addKind(fragment, kind, file.getName());
        String apiVersion = defaultApiVersion;
        if (Objects.equals(kind, "Deployment") || Objects.equals(kind, "Ingress")) {
            apiVersion = apiExtensionsVersion;
        }
        KubernetesResourceUtil.addIfNotExistent(fragment, "apiVersion", apiVersion);
        Map<String, Object> metaMap = KubernetesResourceUtil.getMetadata(fragment);
        if (StringUtils.isNotBlank((String)name)) {
            KubernetesResourceUtil.addIfNotExistent(metaMap, "name", name);
        }
        KubernetesResourceUtil.addIfNotExistent(fragment, "apiVersion", defaultApiVersion);
        return fragment;
    }

    private static String getAndValidateKindFromType(File file, String type) {
        String kind = FILENAME_TO_KIND_MAPPER.get(type.toLowerCase());
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Unknown type '%s' for file %s. Must be one of : %s", type, file.getName(), StringUtils.join(FILENAME_TO_KIND_MAPPER.keySet().iterator(), (String)", ")));
        }
        return kind;
    }

    private static void addKind(Map<String, Object> fragment, String kind, String fileName) {
        if (kind == null && !fragment.containsKey("kind")) {
            throw new IllegalArgumentException("No type given as part of the file name (e.g. 'app-rc.yml') and no 'Kind' defined in resource descriptor " + fileName);
        }
        KubernetesResourceUtil.addIfNotExistent(fragment, "kind", kind);
    }

    private static Map<String, Object> getMetadata(Map<String, Object> fragment) {
        HashMap meta = (HashMap)fragment.get("metadata");
        if (meta == null) {
            meta = new HashMap();
            fragment.put("metadata", meta);
        }
        return meta;
    }

    private static void addIfNotExistent(Map<String, Object> fragment, String key, String value) {
        if (!fragment.containsKey(key)) {
            fragment.put(key, value);
        }
    }

    private static Map<String, Object> readFragment(File file, String ext) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)("json".equals(ext) ? new JsonFactory() : new YAMLFactory()));
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        return (Map)mapper.readValue(file, (TypeReference)typeRef);
    }

    public static String getNameWithSuffix(String name, String kind) {
        String suffix = KIND_TO_FILENAME_MAPPER.get(kind);
        return suffix != null ? name + "-" + suffix : name;
    }

    static {
        for (int i = 0; i < mappings.length; i += 2) {
            FILENAME_TO_KIND_MAPPER.put(mappings[i], mappings[i + 1]);
            KIND_TO_FILENAME_MAPPER.put(mappings[i + 1], mappings[i]);
        }
    }
}

