/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.maven.core.config.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.plugins.annotations.Parameter;

public class ProcessorConfig {
    public static final ProcessorConfig EMPTY = new ProcessorConfig();
    @JsonProperty(value="includes")
    @Parameter
    private List<String> includes;
    @JsonProperty(value="excludes")
    @Parameter
    private Set<String> excludes;
    @JsonProperty(value="config")
    @Parameter
    Map<String, TreeMap> config = new HashMap<String, TreeMap>();

    public ProcessorConfig() {
    }

    public ProcessorConfig(List<String> includes, Set<String> excludes, Map<String, TreeMap> config) {
        this.includes = includes;
        this.excludes = excludes;
        if (config != null) {
            this.config = config;
        }
    }

    public String getConfig(String name, String key) {
        TreeMap processorMap = this.config.get(name);
        return processorMap != null ? (String)processorMap.get(key) : null;
    }

    public boolean use(String name) {
        if (this.includes != null && this.includes.size() > 0 && this.includes.contains(name)) {
            return true;
        }
        if (this.excludes != null && this.excludes.contains(name)) {
            return false;
        }
        return this.includes == null || this.includes.size() <= 0;
    }

    public <T extends Named> List<T> order(List<T> namedList, String type) {
        if (this.includes == null) {
            return namedList;
        }
        ArrayList<Named> ret = new ArrayList<Named>();
        HashMap<String, Named> lookup = new HashMap<String, Named>();
        for (Named named : namedList) {
            lookup.put(named.getName(), named);
        }
        for (String inc : this.includes) {
            Named named = (Named)lookup.get(inc);
            if (named == null) {
                throw new IllegalArgumentException("No " + type + " with name '" + inc + "' found to include. " + "Please check spelling and your project dependencies");
            }
            ret.add(named);
        }
        return ret;
    }
}

