/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.access;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.Strings;

public class ClusterAccess {
    private String namespace;

    public ClusterAccess(String namespace) {
        this.namespace = namespace;
        if (Strings.isNullOrBlank((String)this.namespace)) {
            this.namespace = KubernetesHelper.defaultNamespace();
        }
        if (Strings.isNullOrBlank((String)this.namespace)) {
            this.namespace = "default";
        }
    }

    public KubernetesClient createKubernetesClient() {
        Config config = this.createDefaultConfig();
        return new DefaultKubernetesClient(this.createDefaultConfig());
    }

    public OpenShiftClient createOpenShiftClient() {
        return new DefaultOpenShiftClient(this.createDefaultConfig());
    }

    private Config createDefaultConfig() {
        return ((ConfigBuilder)new ConfigBuilder().withNamespace(this.getNamespace())).build();
    }

    public String getNamespace() {
        return this.namespace;
    }
}

