/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.config;

import io.fabric8.maven.core.config.AnnotationConfig;
import io.fabric8.maven.core.config.MetricsConfig;
import io.fabric8.maven.core.config.ProbeConfig;
import io.fabric8.maven.core.config.ServiceConfig;
import io.fabric8.maven.core.config.VolumeConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;

public class ResourceConfig {
    @Parameter
    private Map<String, String> env;
    @Parameter
    private Map<String, String> labels;
    @Parameter
    private AnnotationConfig annotations;
    @Parameter
    private List<VolumeConfig> volumes;
    @Parameter(defaultValue="${project.artifactId}")
    private String replicaSetName;
    @Parameter
    private List<ServiceConfig> services;
    @Parameter
    private ProbeConfig liveness;
    @Parameter
    private ProbeConfig readiness;
    @Parameter
    private MetricsConfig metrics;
    @Parameter
    private boolean containerPrivileged = false;
    @Parameter
    private String imagePullPolicy;
    @Parameter
    private Map<String, Integer> ports;
    @Parameter
    private int replicas = 1;
    @Parameter
    private String serviceAccount;
    @Parameter
    private String namespace;

    public Map<String, String> getEnv() {
        return this.env != null ? this.env : Collections.emptyMap();
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public AnnotationConfig getAnnotations() {
        return this.annotations != null ? this.annotations : new AnnotationConfig();
    }

    public List<VolumeConfig> getVolumes() {
        return this.volumes;
    }

    public List<ServiceConfig> getServices() {
        return this.services;
    }

    public ProbeConfig getLiveness() {
        return this.liveness;
    }

    public ProbeConfig getReadiness() {
        return this.readiness;
    }

    public MetricsConfig getMetrics() {
        return this.metrics;
    }

    public boolean isContainerPrivileged() {
        return this.containerPrivileged;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getReplicaSetName() {
        return this.replicaSetName;
    }

    public Map<String, Integer> getPorts() {
        return this.ports;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static class Builder {
        private ResourceConfig config = new ResourceConfig();

        public Builder replicaSetName(String name) {
            this.config.replicaSetName = name;
            return this;
        }

        public Builder imagePullPolicy(String policy) {
            this.config.imagePullPolicy = policy;
            return this;
        }

        public ResourceConfig build() {
            return this.config;
        }
    }
}

