/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.PodTemplateHandler;
import io.fabric8.maven.docker.config.ImageConfiguration;
import java.util.List;

public class ReplicationControllerHandler {
    private final PodTemplateHandler podTemplateHandler;

    ReplicationControllerHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public ReplicationController getReplicationController(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicationControllerBuilder)((ReplicationControllerBuilder)new ReplicationControllerBuilder().withMetadata(this.createRcMetaData(config))).withSpec(this.createRcSpec(config, images))).build();
    }

    private ObjectMeta createRcMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getReplicaSetName(), (String)"replication controller name"))).withAnnotations(config.getAnnotations().getReplicaSet())).build();
    }

    private ReplicationControllerSpec createRcSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicationControllerSpecBuilder)((ReplicationControllerSpecBuilder)new ReplicationControllerSpecBuilder().withReplicas(Integer.valueOf(config.getReplicas()))).withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

