/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSet;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetSpecBuilder;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.PodTemplateHandler;
import io.fabric8.maven.docker.config.ImageConfiguration;
import java.util.List;

public class StatefulSetHandler {
    private final PodTemplateHandler podTemplateHandler;

    StatefulSetHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public StatefulSet getStatefulSet(ResourceConfig config, List<ImageConfiguration> images) {
        return ((StatefulSetBuilder)((StatefulSetBuilder)new StatefulSetBuilder().withMetadata(this.createStatefulSetMetaData(config))).withSpec(this.createStatefulSetSpec(config, images))).build();
    }

    private ObjectMeta createStatefulSetMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"controller name"))).build();
    }

    private StatefulSetSpec createStatefulSetSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)new StatefulSetSpecBuilder().withReplicas(Integer.valueOf(config.getReplicas()))).withServiceName(config.getControllerName())).withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

