/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.karaf;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.BaseGenerator;
import io.fabric8.maven.generator.api.FromSelector;
import io.fabric8.maven.generator.api.MavenGeneratorContext;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class KarafGenerator
extends BaseGenerator {
    public KarafGenerator(MavenGeneratorContext context) {
        super(context, "karaf", (FromSelector)new FromSelector.Default(context, "fabric8/s2i-karaf", "fabric8/s2i-karaf", "jboss-fuse-6/fis-karaf-openshift", "jboss-fuse-6/fis-karaf-openshift"));
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs) {
        if (this.isApplicable() && this.shouldAddDefaultImage(configs)) {
            ImageConfiguration.Builder imageBuilder = new ImageConfiguration.Builder();
            BuildImageConfiguration.Builder buildBuilder = new BuildImageConfiguration.Builder().assembly(this.createAssembly()).from(this.getFrom()).ports(this.extractPorts()).cmd(this.getConfig(Config.cmd));
            this.addLatestTagIfSnapshot(buildBuilder);
            imageBuilder.name(this.getImageName()).alias(this.getAlias()).buildConfig(buildBuilder.build());
            configs.add(imageBuilder.build());
            return configs;
        }
        return configs;
    }

    public boolean isApplicable() {
        MavenProject project = this.getProject();
        return MavenUtil.hasPlugin((MavenProject)project, (String)"org.apache.karaf.tooling:karaf-maven-plugin");
    }

    private List<String> extractPorts() {
        ArrayList<String> answer = new ArrayList<String>();
        this.addPortIfValid(answer, this.getConfig(Config.webPort));
        this.addPortIfValid(answer, this.getConfig(Config.jolokiaPort));
        return answer;
    }

    private void addPortIfValid(List<String> list, String port) {
        if (Strings.isNotBlank((String)port)) {
            list.add(port);
        }
    }

    private AssemblyConfiguration createAssembly() {
        return new AssemblyConfiguration.Builder().basedir(this.getConfig(Config.baseDir)).user(this.getConfig(Config.user)).descriptorRef("karaf").build();
    }

    private static enum Config implements Configs.Key
    {
        baseDir{
            {
                this.d = "/deployments/";
            }
        }
        ,
        user{
            {
                this.d = "jboss:jboss:jboss";
            }
        }
        ,
        cmd{
            {
                this.d = "/deployments/deploy-and-run.sh";
            }
        }
        ,
        webPort{
            {
                this.d = "8181";
            }
        }
        ,
        jolokiaPort{
            {
                this.d = "8778";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

