/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.maven.AbstractNamespacedMojo;
import io.fabric8.maven.ApplyMojo;
import io.fabric8.openshift.api.model.Route;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="create-routes", requiresProject=false)
public class CreateRoutesMojo
extends AbstractNamespacedMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            List items;
            KubernetesClient kubernetes = this.getKubernetes();
            Controller controller = this.createController();
            String namespace = this.getNamespace();
            Log log = this.getLog();
            log.info((CharSequence)("Querying services in namespace: " + namespace + " on Kubernetes address: " + kubernetes.getMasterUrl()));
            ServiceList services = (ServiceList)((ClientNonNamespaceOperation)kubernetes.services().inNamespace(namespace)).list();
            if (services != null && (items = services.getItems()) != null) {
                log.info((CharSequence)("Found " + items.size() + " service(s)"));
                String routeDomainPostfix = this.routeDomain;
                for (Service service : items) {
                    Route route = ApplyMojo.createRouteForService(routeDomainPostfix, namespace, service, log);
                    if (route == null) continue;
                    controller.applyRoute(route, "Service " + KubernetesHelper.getName((HasMetadata)service));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to load environment schemas: " + e, e);
        }
    }
}

