/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.config.MetaDataConfig;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.util.ClassUtil;
import io.fabric8.maven.core.util.PluginServiceFactory;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.Enricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.plugin.enricher.MetadataVisitor;
import io.fabric8.maven.plugin.enricher.SelectorVisitor;
import io.fabric8.utils.Function;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public class EnricherManager {
    private final MetaDataConfig labelConfig;
    private final MetaDataConfig annotationConfig;
    private List<Enricher> enrichers;
    private final ProcessorConfig defaultEnricherConfig;
    private Logger log;
    private final MetadataVisitor<?>[] metaDataVisitors;
    private final SelectorVisitor<?>[] selectorVisitorCreators;

    public EnricherManager(ResourceConfig resourceConfig, EnricherContext enricherContext) {
        PluginServiceFactory pluginFactory = new PluginServiceFactory((Object)enricherContext, new ClassLoader[0]);
        if (enricherContext.isUseProjectClasspath()) {
            pluginFactory.addAdditionalClassLoader((ClassLoader)ClassUtil.createProjectClassLoader((MavenProject)enricherContext.getProject(), (Logger)enricherContext.getLog()));
        }
        this.log = enricherContext.getLog();
        this.defaultEnricherConfig = enricherContext.getConfig();
        this.enrichers = pluginFactory.createServiceObjects(new String[]{"META-INF/fabric8-enricher-default", "META-INF/fabric8/enricher-default", "META-INF/fabric8-enricher", "META-INF/fabric8/enricher"});
        if (resourceConfig != null) {
            this.labelConfig = resourceConfig.getLabels();
            this.annotationConfig = resourceConfig.getAnnotations();
        } else {
            this.labelConfig = null;
            this.annotationConfig = null;
        }
        this.logEnrichers(this.filterEnrichers(this.defaultEnricherConfig, this.enrichers));
        this.metaDataVisitors = new MetadataVisitor[]{new MetadataVisitor.DeploymentBuilderVisitor(resourceConfig, this), new MetadataVisitor.ReplicaSet(resourceConfig, this), new MetadataVisitor.ReplicationControllerBuilderVisitor(resourceConfig, this), new MetadataVisitor.ServiceBuilderVisitor(resourceConfig, this), new MetadataVisitor.PodTemplateSpecBuilderVisitor(resourceConfig, this), new MetadataVisitor.DaemonSetBuilderVisitor(resourceConfig, this), new MetadataVisitor.StatefulSetBuilderVisitor(resourceConfig, this), new MetadataVisitor.JobBuilderVisitor(resourceConfig, this)};
        this.selectorVisitorCreators = new SelectorVisitor[]{new SelectorVisitor.DeploymentSpecBuilderVisitor(this), new SelectorVisitor.ReplicaSetSpecBuilderVisitor(this), new SelectorVisitor.ReplicationControllerSpecBuilderVisitor(this), new SelectorVisitor.ServiceSpecBuilderVisitor(this), new SelectorVisitor.DaemonSetSpecBuilderVisitor(this), new SelectorVisitor.StatefulSetSpecBuilderVisitor(this), new SelectorVisitor.JobSpecBuilderVisitor(this)};
    }

    public void createDefaultResources(KubernetesListBuilder builder) {
        this.createDefaultResources(this.defaultEnricherConfig, builder);
    }

    public void createDefaultResources(ProcessorConfig enricherConfig, final KubernetesListBuilder builder) {
        this.loop(enricherConfig, new Function<Enricher, Void>(){

            public Void apply(Enricher enricher) {
                enricher.addMissingResources(builder);
                return null;
            }
        });
    }

    public void enrich(KubernetesListBuilder builder) {
        this.enrich(this.defaultEnricherConfig, builder);
    }

    public void enrich(ProcessorConfig config, KubernetesListBuilder builder) {
        this.enrichLabels(config, builder);
        this.addMissingSelectors(config, builder);
        this.adapt(config, builder);
    }

    private void logEnrichers(List<Enricher> enrichers) {
        this.log.verbose("Enrichers:", new Object[0]);
        for (Enricher enricher : enrichers) {
            this.log.verbose("- %s", new Object[]{enricher.getName()});
        }
    }

    private void enrichLabels(ProcessorConfig config, KubernetesListBuilder builder) {
        this.visit(config, builder, this.metaDataVisitors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMissingSelectors(ProcessorConfig config, KubernetesListBuilder builder) {
        SelectorVisitor.setProcessorConfig(config);
        try {
            for (SelectorVisitor<?> visitor : this.selectorVisitorCreators) {
                builder.accept(visitor);
            }
        }
        finally {
            SelectorVisitor.clearProcessorConfig();
        }
    }

    private void adapt(ProcessorConfig enricherConfig, final KubernetesListBuilder builder) {
        this.loop(enricherConfig, new Function<Enricher, Void>(){

            public Void apply(Enricher enricher) {
                enricher.adapt(builder);
                return null;
            }
        });
    }

    Map<String, String> extractLabels(ProcessorConfig config, Kind kind) {
        return this.extract(config, Extractor.LABEL_EXTRACTOR, kind);
    }

    Map<String, String> extractAnnotations(ProcessorConfig config, Kind kind) {
        return this.extract(config, Extractor.ANNOTATION_EXTRACTOR, kind);
    }

    Map<String, String> extractSelector(ProcessorConfig config, Kind kind) {
        return this.extract(config, Extractor.SELECTOR_EXTRACTOR, kind);
    }

    private List<Enricher> filterEnrichers(ProcessorConfig config, List<Enricher> enrichers) {
        return config.prepareProcessors(enrichers, "enricher");
    }

    private void loop(ProcessorConfig config, Function<Enricher, Void> function) {
        for (Enricher enricher : this.filterEnrichers(config, this.enrichers)) {
            function.apply((Object)enricher);
        }
    }

    private Map<String, String> extract(ProcessorConfig config, Extractor extractor, Kind kind) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Enricher enricher : this.filterEnrichers(config, this.enrichers)) {
            this.putAllIfNotNull(ret, extractor.extract(enricher, kind));
        }
        return ret;
    }

    private void putAllIfNotNull(Map<String, String> ret, Map<String, String> toPut) {
        if (toPut != null) {
            ret.putAll(toPut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visit(ProcessorConfig config, KubernetesListBuilder builder, MetadataVisitor<?>[] visitors) {
        MetadataVisitor.setProcessorConfig(config);
        try {
            for (MetadataVisitor<?> visitor : visitors) {
                builder.accept(visitor);
            }
        }
        finally {
            MetadataVisitor.clearProcessorConfig();
        }
    }

    static enum Extractor {
        LABEL_EXTRACTOR{

            @Override
            public Map<String, String> extract(Enricher enricher, Kind kind) {
                return enricher.getLabels(kind);
            }
        }
        ,
        ANNOTATION_EXTRACTOR{

            @Override
            public Map<String, String> extract(Enricher enricher, Kind kind) {
                return enricher.getAnnotations(kind);
            }
        }
        ,
        SELECTOR_EXTRACTOR{

            @Override
            public Map<String, String> extract(Enricher enricher, Kind kind) {
                return enricher.getSelector(kind);
            }
        };


        abstract Map<String, String> extract(Enricher var1, Kind var2);
    }
}

