/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.stat;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.gitective.core.stat.UserCommitActivity;

public class CommitHistogram
implements Serializable {
    private static final long serialVersionUID = 5626774395562827167L;
    protected final Map<String, UserCommitActivity> users = new HashMap<String, UserCommitActivity>();

    public CommitHistogram include(RevCommit commit, PersonIdent user) {
        String email = user.getEmailAddress();
        UserCommitActivity activity = this.users.get(email);
        if (activity == null) {
            activity = new UserCommitActivity(user.getName(), email);
            this.users.put(email, activity);
        }
        activity.include(commit, user);
        return this;
    }

    public CommitHistogram clear() {
        this.users.clear();
        return this;
    }

    public UserCommitActivity getActivity(String email) {
        return email != null ? this.users.get(email) : null;
    }

    public UserCommitActivity[] getUserActivity(Comparator<UserCommitActivity> comparator) {
        UserCommitActivity[] activity = this.users.values().toArray(new UserCommitActivity[this.users.size()]);
        if (comparator != null) {
            Arrays.sort(activity, comparator);
        }
        return activity;
    }

    public UserCommitActivity[] getUserActivity() {
        return this.getUserActivity(null);
    }
}

