/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.DestinationRuleSpec;
import io.fabric8.istio.api.networking.v1alpha3.DestinationRuleSpecFluent;
import io.fabric8.istio.api.networking.v1alpha3.Subset;
import io.fabric8.istio.api.networking.v1alpha3.SubsetBuilder;
import io.fabric8.istio.api.networking.v1alpha3.SubsetFluentImpl;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicy;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyBuilder;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DestinationRuleSpecFluentImpl<A extends DestinationRuleSpecFluent<A>>
extends BaseFluent<A>
implements DestinationRuleSpecFluent<A> {
    private List<String> exportTo;
    private String host;
    private List<SubsetBuilder> subsets;
    private TrafficPolicyBuilder trafficPolicy;

    public DestinationRuleSpecFluentImpl() {
    }

    public DestinationRuleSpecFluentImpl(DestinationRuleSpec instance) {
        this.withExportTo(instance.getExportTo());
        this.withHost(instance.getHost());
        this.withSubsets(instance.getSubsets());
        this.withTrafficPolicy(instance.getTrafficPolicy());
    }

    @Override
    public A addToExportTo(Integer index, String item) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        this.exportTo.add(index, item);
        return (A)this;
    }

    @Override
    public A setToExportTo(Integer index, String item) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        this.exportTo.set(index, item);
        return (A)this;
    }

    @Override
    public A addToExportTo(String ... items) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        for (String item : items) {
            this.exportTo.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToExportTo(Collection<String> items) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        for (String item : items) {
            this.exportTo.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExportTo(String ... items) {
        for (String item : items) {
            if (this.exportTo == null) continue;
            this.exportTo.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExportTo(Collection<String> items) {
        for (String item : items) {
            if (this.exportTo == null) continue;
            this.exportTo.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExportTo() {
        return this.exportTo;
    }

    @Override
    public String getExportTo(Integer index) {
        return this.exportTo.get(index);
    }

    @Override
    public String getFirstExportTo() {
        return this.exportTo.get(0);
    }

    @Override
    public String getLastExportTo() {
        return this.exportTo.get(this.exportTo.size() - 1);
    }

    @Override
    public String getMatchingExportTo(Predicate<String> predicate) {
        for (String item : this.exportTo) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExportTo(Predicate<String> predicate) {
        for (String item : this.exportTo) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExportTo(List<String> exportTo) {
        if (exportTo != null) {
            this.exportTo = new ArrayList<String>();
            for (String item : exportTo) {
                this.addToExportTo(item);
            }
        } else {
            this.exportTo = null;
        }
        return (A)this;
    }

    @Override
    public A withExportTo(String ... exportTo) {
        if (this.exportTo != null) {
            this.exportTo.clear();
        }
        if (exportTo != null) {
            for (String item : exportTo) {
                this.addToExportTo(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExportTo() {
        return this.exportTo != null && !this.exportTo.isEmpty();
    }

    @Override
    public A addNewExportTo(String arg0) {
        return this.addToExportTo(new String(arg0));
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    @Deprecated
    public A withNewHost(String arg0) {
        return this.withHost(new String(arg0));
    }

    @Override
    public A addToSubsets(Integer index, Subset item) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<SubsetBuilder>();
        }
        SubsetBuilder builder = new SubsetBuilder(item);
        this._visitables.get((Object)"subsets").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"subsets").size(), builder);
        this.subsets.add(index >= 0 ? index.intValue() : this.subsets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubsets(Integer index, Subset item) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<SubsetBuilder>();
        }
        SubsetBuilder builder = new SubsetBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"subsets").size()) {
            this._visitables.get((Object)"subsets").add(builder);
        } else {
            this._visitables.get((Object)"subsets").set(index, builder);
        }
        if (index < 0 || index >= this.subsets.size()) {
            this.subsets.add(builder);
        } else {
            this.subsets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubsets(Subset ... items) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<SubsetBuilder>();
        }
        for (Subset item : items) {
            SubsetBuilder builder = new SubsetBuilder(item);
            this._visitables.get((Object)"subsets").add(builder);
            this.subsets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubsets(Collection<Subset> items) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<SubsetBuilder>();
        }
        for (Subset item : items) {
            SubsetBuilder builder = new SubsetBuilder(item);
            this._visitables.get((Object)"subsets").add(builder);
            this.subsets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubsets(Subset ... items) {
        for (Subset item : items) {
            SubsetBuilder builder = new SubsetBuilder(item);
            this._visitables.get((Object)"subsets").remove(builder);
            if (this.subsets == null) continue;
            this.subsets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubsets(Collection<Subset> items) {
        for (Subset item : items) {
            SubsetBuilder builder = new SubsetBuilder(item);
            this._visitables.get((Object)"subsets").remove(builder);
            if (this.subsets == null) continue;
            this.subsets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubsets(Predicate<SubsetBuilder> predicate) {
        if (this.subsets == null) {
            return (A)this;
        }
        Iterator<SubsetBuilder> each = this.subsets.iterator();
        List visitables = this._visitables.get((Object)"subsets");
        while (each.hasNext()) {
            SubsetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Subset> getSubsets() {
        return DestinationRuleSpecFluentImpl.build(this.subsets);
    }

    @Override
    public List<Subset> buildSubsets() {
        return DestinationRuleSpecFluentImpl.build(this.subsets);
    }

    @Override
    public Subset buildSubset(Integer index) {
        return this.subsets.get(index).build();
    }

    @Override
    public Subset buildFirstSubset() {
        return this.subsets.get(0).build();
    }

    @Override
    public Subset buildLastSubset() {
        return this.subsets.get(this.subsets.size() - 1).build();
    }

    @Override
    public Subset buildMatchingSubset(Predicate<SubsetBuilder> predicate) {
        for (SubsetBuilder item : this.subsets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubset(Predicate<SubsetBuilder> predicate) {
        for (SubsetBuilder item : this.subsets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubsets(List<Subset> subsets) {
        if (this.subsets != null) {
            this._visitables.get((Object)"subsets").removeAll(this.subsets);
        }
        if (subsets != null) {
            this.subsets = new ArrayList<SubsetBuilder>();
            for (Subset item : subsets) {
                this.addToSubsets(item);
            }
        } else {
            this.subsets = null;
        }
        return (A)this;
    }

    @Override
    public A withSubsets(Subset ... subsets) {
        if (this.subsets != null) {
            this.subsets.clear();
        }
        if (subsets != null) {
            for (Subset item : subsets) {
                this.addToSubsets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubsets() {
        return this.subsets != null && !this.subsets.isEmpty();
    }

    @Override
    public DestinationRuleSpecFluent.SubsetsNested<A> addNewSubset() {
        return new SubsetsNestedImpl();
    }

    @Override
    public DestinationRuleSpecFluent.SubsetsNested<A> addNewSubsetLike(Subset item) {
        return new SubsetsNestedImpl(-1, item);
    }

    @Override
    public DestinationRuleSpecFluent.SubsetsNested<A> setNewSubsetLike(Integer index, Subset item) {
        return new SubsetsNestedImpl(index, item);
    }

    @Override
    public DestinationRuleSpecFluent.SubsetsNested<A> editSubset(Integer index) {
        if (this.subsets.size() <= index) {
            throw new RuntimeException("Can't edit subsets. Index exceeds size.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    @Override
    public DestinationRuleSpecFluent.SubsetsNested<A> editFirstSubset() {
        if (this.subsets.size() == 0) {
            throw new RuntimeException("Can't edit first subsets. The list is empty.");
        }
        return this.setNewSubsetLike(0, this.buildSubset(0));
    }

    @Override
    public DestinationRuleSpecFluent.SubsetsNested<A> editLastSubset() {
        int index = this.subsets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subsets. The list is empty.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    @Override
    public DestinationRuleSpecFluent.SubsetsNested<A> editMatchingSubset(Predicate<SubsetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subsets.size(); ++i) {
            if (!predicate.test(this.subsets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subsets. No match found.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    @Override
    @Deprecated
    public TrafficPolicy getTrafficPolicy() {
        return this.trafficPolicy != null ? this.trafficPolicy.build() : null;
    }

    @Override
    public TrafficPolicy buildTrafficPolicy() {
        return this.trafficPolicy != null ? this.trafficPolicy.build() : null;
    }

    @Override
    public A withTrafficPolicy(TrafficPolicy trafficPolicy) {
        this._visitables.get((Object)"trafficPolicy").remove(this.trafficPolicy);
        if (trafficPolicy != null) {
            this.trafficPolicy = new TrafficPolicyBuilder(trafficPolicy);
            this._visitables.get((Object)"trafficPolicy").add(this.trafficPolicy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTrafficPolicy() {
        return this.trafficPolicy != null;
    }

    @Override
    public DestinationRuleSpecFluent.TrafficPolicyNested<A> withNewTrafficPolicy() {
        return new TrafficPolicyNestedImpl();
    }

    @Override
    public DestinationRuleSpecFluent.TrafficPolicyNested<A> withNewTrafficPolicyLike(TrafficPolicy item) {
        return new TrafficPolicyNestedImpl(item);
    }

    @Override
    public DestinationRuleSpecFluent.TrafficPolicyNested<A> editTrafficPolicy() {
        return this.withNewTrafficPolicyLike(this.getTrafficPolicy());
    }

    @Override
    public DestinationRuleSpecFluent.TrafficPolicyNested<A> editOrNewTrafficPolicy() {
        return this.withNewTrafficPolicyLike(this.getTrafficPolicy() != null ? this.getTrafficPolicy() : new TrafficPolicyBuilder().build());
    }

    @Override
    public DestinationRuleSpecFluent.TrafficPolicyNested<A> editOrNewTrafficPolicyLike(TrafficPolicy item) {
        return this.withNewTrafficPolicyLike(this.getTrafficPolicy() != null ? this.getTrafficPolicy() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DestinationRuleSpecFluentImpl that = (DestinationRuleSpecFluentImpl)o;
        if (this.exportTo != null ? !this.exportTo.equals(that.exportTo) : that.exportTo != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.subsets != null ? !this.subsets.equals(that.subsets) : that.subsets != null) {
            return false;
        }
        return !(this.trafficPolicy != null ? !this.trafficPolicy.equals(that.trafficPolicy) : that.trafficPolicy != null);
    }

    public int hashCode() {
        return Objects.hash(this.exportTo, this.host, this.subsets, this.trafficPolicy, super.hashCode());
    }

    public class TrafficPolicyNestedImpl<N>
    extends TrafficPolicyFluentImpl<DestinationRuleSpecFluent.TrafficPolicyNested<N>>
    implements DestinationRuleSpecFluent.TrafficPolicyNested<N>,
    Nested<N> {
        TrafficPolicyBuilder builder;

        TrafficPolicyNestedImpl(TrafficPolicy item) {
            this.builder = new TrafficPolicyBuilder(this, item);
        }

        TrafficPolicyNestedImpl() {
            this.builder = new TrafficPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)DestinationRuleSpecFluentImpl.this.withTrafficPolicy(this.builder.build());
        }

        @Override
        public N endTrafficPolicy() {
            return this.and();
        }
    }

    public class SubsetsNestedImpl<N>
    extends SubsetFluentImpl<DestinationRuleSpecFluent.SubsetsNested<N>>
    implements DestinationRuleSpecFluent.SubsetsNested<N>,
    Nested<N> {
        SubsetBuilder builder;
        Integer index;

        SubsetsNestedImpl(Integer index, Subset item) {
            this.index = index;
            this.builder = new SubsetBuilder(this, item);
        }

        SubsetsNestedImpl() {
            this.index = -1;
            this.builder = new SubsetBuilder(this);
        }

        @Override
        public N and() {
            return (N)DestinationRuleSpecFluentImpl.this.setToSubsets(this.index, this.builder.build());
        }

        @Override
        public N endSubset() {
            return this.and();
        }
    }
}

