/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.internal.protobuf.types;

import io.fabric8.istio.api.internal.protobuf.types.ListValue;
import io.fabric8.istio.api.internal.protobuf.types.ListValueFluent;
import io.fabric8.istio.api.internal.protobuf.types.Value;
import io.fabric8.istio.api.internal.protobuf.types.ValueBuilder;
import io.fabric8.istio.api.internal.protobuf.types.ValueFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ListValueFluentImpl<A extends ListValueFluent<A>>
extends BaseFluent<A>
implements ListValueFluent<A> {
    private ArrayList<ValueBuilder> values = new ArrayList();

    public ListValueFluentImpl() {
    }

    public ListValueFluentImpl(ListValue instance) {
        this.withValues(instance.getValues());
    }

    @Override
    public A addToValues(Integer index, Value item) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        ValueBuilder builder = new ValueBuilder(item);
        this._visitables.get((Object)"values").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"values").size(), builder);
        this.values.add(index >= 0 ? index.intValue() : this.values.size(), builder);
        return (A)this;
    }

    @Override
    public A setToValues(Integer index, Value item) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        ValueBuilder builder = new ValueBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"values").size()) {
            this._visitables.get((Object)"values").add(builder);
        } else {
            this._visitables.get((Object)"values").set(index, builder);
        }
        if (index < 0 || index >= this.values.size()) {
            this.values.add(builder);
        } else {
            this.values.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToValues(Value ... items) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (Value item : items) {
            ValueBuilder builder = new ValueBuilder(item);
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToValues(Collection<Value> items) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (Value item : items) {
            ValueBuilder builder = new ValueBuilder(item);
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromValues(Value ... items) {
        for (Value item : items) {
            ValueBuilder builder = new ValueBuilder(item);
            this._visitables.get((Object)"values").remove(builder);
            if (this.values == null) continue;
            this.values.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromValues(Collection<Value> items) {
        for (Value item : items) {
            ValueBuilder builder = new ValueBuilder(item);
            this._visitables.get((Object)"values").remove(builder);
            if (this.values == null) continue;
            this.values.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromValues(Predicate<ValueBuilder> predicate) {
        if (this.values == null) {
            return (A)this;
        }
        Iterator<ValueBuilder> each = this.values.iterator();
        List visitables = this._visitables.get((Object)"values");
        while (each.hasNext()) {
            ValueBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Value> getValues() {
        return this.values != null ? ListValueFluentImpl.build(this.values) : null;
    }

    @Override
    public List<Value> buildValues() {
        return this.values != null ? ListValueFluentImpl.build(this.values) : null;
    }

    @Override
    public Value buildValue(Integer index) {
        return this.values.get(index).build();
    }

    @Override
    public Value buildFirstValue() {
        return this.values.get(0).build();
    }

    @Override
    public Value buildLastValue() {
        return this.values.get(this.values.size() - 1).build();
    }

    @Override
    public Value buildMatchingValue(Predicate<ValueBuilder> predicate) {
        for (ValueBuilder item : this.values) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingValue(Predicate<ValueBuilder> predicate) {
        for (ValueBuilder item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withValues(List<Value> values) {
        if (this.values != null) {
            this._visitables.get((Object)"values").removeAll(this.values);
        }
        if (values != null) {
            this.values = new ArrayList();
            for (Value item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)this;
    }

    @Override
    public A withValues(Value ... values) {
        if (this.values != null) {
            this.values.clear();
        }
        if (values != null) {
            for (Value item : values) {
                this.addToValues(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    @Override
    public ListValueFluent.ValuesNested<A> addNewValue() {
        return new ValuesNestedImpl();
    }

    @Override
    public ListValueFluent.ValuesNested<A> addNewValueLike(Value item) {
        return new ValuesNestedImpl(-1, item);
    }

    @Override
    public ListValueFluent.ValuesNested<A> setNewValueLike(Integer index, Value item) {
        return new ValuesNestedImpl(index, item);
    }

    @Override
    public ListValueFluent.ValuesNested<A> editValue(Integer index) {
        if (this.values.size() <= index) {
            throw new RuntimeException("Can't edit values. Index exceeds size.");
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    @Override
    public ListValueFluent.ValuesNested<A> editFirstValue() {
        if (this.values.size() == 0) {
            throw new RuntimeException("Can't edit first values. The list is empty.");
        }
        return this.setNewValueLike(0, this.buildValue(0));
    }

    @Override
    public ListValueFluent.ValuesNested<A> editLastValue() {
        int index = this.values.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last values. The list is empty.");
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    @Override
    public ListValueFluent.ValuesNested<A> editMatchingValue(Predicate<ValueBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.values.size(); ++i) {
            if (!predicate.test(this.values.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching values. No match found.");
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListValueFluentImpl that = (ListValueFluentImpl)o;
        return !(this.values != null ? !this.values.equals(that.values) : that.values != null);
    }

    public int hashCode() {
        return Objects.hash(this.values, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(this.values);
        }
        sb.append("}");
        return sb.toString();
    }

    class ValuesNestedImpl<N>
    extends ValueFluentImpl<ListValueFluent.ValuesNested<N>>
    implements ListValueFluent.ValuesNested<N>,
    Nested<N> {
        ValueBuilder builder;
        Integer index;

        ValuesNestedImpl(Integer index, Value item) {
            this.index = index;
            this.builder = new ValueBuilder(this, item);
        }

        ValuesNestedImpl() {
            this.index = -1;
            this.builder = new ValueBuilder(this);
        }

        @Override
        public N and() {
            return (N)ListValueFluentImpl.this.setToValues(this.index, this.builder.build());
        }

        @Override
        public N endValue() {
            return this.and();
        }
    }
}

