/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.internal.protobuf.types;

import io.fabric8.istio.api.internal.protobuf.types.ListValue;
import io.fabric8.istio.api.internal.protobuf.types.Value;
import io.fabric8.istio.api.internal.protobuf.types.ValueBuilder;
import io.fabric8.istio.api.internal.protobuf.types.ValueFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ListValueFluent<A extends ListValueFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ValueBuilder> values = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ListValueFluent() {
    }

    public ListValueFluent(ListValue instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ListValue instance) {
        ListValue listValue = instance = instance != null ? instance : new ListValue();
        if (instance != null) {
            this.withValues(instance.getValues());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToValues(int index, Value item) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        ValueBuilder builder = new ValueBuilder(item);
        if (index < 0 || index >= this.values.size()) {
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        } else {
            this._visitables.get((Object)"values").add(index, builder);
            this.values.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToValues(int index, Value item) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        ValueBuilder builder = new ValueBuilder(item);
        if (index < 0 || index >= this.values.size()) {
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        } else {
            this._visitables.get((Object)"values").set(index, builder);
            this.values.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToValues(Value ... items) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (Value item : items) {
            ValueBuilder builder = new ValueBuilder(item);
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToValues(Collection<Value> items) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (Value item : items) {
            ValueBuilder builder = new ValueBuilder(item);
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromValues(Value ... items) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        for (Value item : items) {
            ValueBuilder builder = new ValueBuilder(item);
            this._visitables.get((Object)"values").remove((Object)builder);
            this.values.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromValues(Collection<Value> items) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        for (Value item : items) {
            ValueBuilder builder = new ValueBuilder(item);
            this._visitables.get((Object)"values").remove((Object)builder);
            this.values.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromValues(Predicate<ValueBuilder> predicate) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        Iterator<ValueBuilder> each = this.values.iterator();
        List visitables = this._visitables.get((Object)"values");
        while (each.hasNext()) {
            ValueBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Value> buildValues() {
        return this.values != null ? ListValueFluent.build(this.values) : null;
    }

    public Value buildValue(int index) {
        return this.values.get(index).build();
    }

    public Value buildFirstValue() {
        return this.values.get(0).build();
    }

    public Value buildLastValue() {
        return this.values.get(this.values.size() - 1).build();
    }

    public Value buildMatchingValue(Predicate<ValueBuilder> predicate) {
        for (ValueBuilder item : this.values) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingValue(Predicate<ValueBuilder> predicate) {
        for (ValueBuilder item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withValues(List<Value> values) {
        if (this.values != null) {
            this._visitables.get((Object)"values").clear();
        }
        if (values != null) {
            this.values = new ArrayList();
            for (Value item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)((Object)this);
    }

    public A withValues(Value ... values) {
        if (this.values != null) {
            this.values.clear();
            this._visitables.remove((Object)"values");
        }
        if (values != null) {
            for (Value item : values) {
                this.addToValues(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    public ValuesNested<A> addNewValue() {
        return new ValuesNested(-1, null);
    }

    public ValuesNested<A> addNewValueLike(Value item) {
        return new ValuesNested(-1, item);
    }

    public ValuesNested<A> setNewValueLike(int index, Value item) {
        return new ValuesNested(index, item);
    }

    public ValuesNested<A> editValue(int index) {
        if (this.values.size() <= index) {
            throw new RuntimeException("Can't edit values. Index exceeds size.");
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    public ValuesNested<A> editFirstValue() {
        if (this.values.size() == 0) {
            throw new RuntimeException("Can't edit first values. The list is empty.");
        }
        return this.setNewValueLike(0, this.buildValue(0));
    }

    public ValuesNested<A> editLastValue() {
        int index = this.values.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last values. The list is empty.");
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    public ValuesNested<A> editMatchingValue(Predicate<ValueBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.values.size(); ++i) {
            if (!predicate.test(this.values.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching values. No match found.");
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListValueFluent that = (ListValueFluent)((Object)o);
        if (!Objects.equals(this.values, that.values)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(this.values + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ValuesNested<N>
    extends ValueFluent<ValuesNested<N>>
    implements Nested<N> {
        ValueBuilder builder;
        int index;

        ValuesNested(int index, Value item) {
            this.index = index;
            this.builder = new ValueBuilder(this, item);
        }

        public N and() {
            return (N)ListValueFluent.this.setToValues(this.index, this.builder.build());
        }

        public N endValue() {
            return this.and();
        }
    }
}

