/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.istio.api.security.v1beta1.JWTHeader;
import io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder;
import io.fabric8.istio.api.security.v1beta1.JWTHeaderFluent;
import io.fabric8.istio.api.security.v1beta1.JWTRule;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class JWTRuleFluent<A extends JWTRuleFluent<A>>
extends BaseFluent<A> {
    private List<String> audiences = new ArrayList<String>();
    private Boolean forwardOriginalToken;
    private ArrayList<JWTHeaderBuilder> fromHeaders = new ArrayList();
    private List<String> fromParams = new ArrayList<String>();
    private String issuer;
    private String jwks;
    private String jwksUri;
    private String outputPayloadToHeader;
    private Map<String, Object> additionalProperties;

    public JWTRuleFluent() {
    }

    public JWTRuleFluent(JWTRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(JWTRule instance) {
        JWTRule jWTRule = instance = instance != null ? instance : new JWTRule();
        if (instance != null) {
            this.withAudiences(instance.getAudiences());
            this.withForwardOriginalToken(instance.getForwardOriginalToken());
            this.withFromHeaders(instance.getFromHeaders());
            this.withFromParams(instance.getFromParams());
            this.withIssuer(instance.getIssuer());
            this.withJwks(instance.getJwks());
            this.withJwksUri(instance.getJwksUri());
            this.withOutputPayloadToHeader(instance.getOutputPayloadToHeader());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)((Object)this);
    }

    public A setToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)((Object)this);
    }

    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAudiences(String ... items) {
        if (this.audiences == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.audiences.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAudiences(Collection<String> items) {
        if (this.audiences == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.audiences.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public String getAudience(int index) {
        return this.audiences.get(index);
    }

    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAudiences(List<String> audiences) {
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)((Object)this);
    }

    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
            this._visitables.remove((Object)"audiences");
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    public Boolean getForwardOriginalToken() {
        return this.forwardOriginalToken;
    }

    public A withForwardOriginalToken(Boolean forwardOriginalToken) {
        this.forwardOriginalToken = forwardOriginalToken;
        return (A)((Object)this);
    }

    public boolean hasForwardOriginalToken() {
        return this.forwardOriginalToken != null;
    }

    public A addToFromHeaders(int index, JWTHeader item) {
        if (this.fromHeaders == null) {
            this.fromHeaders = new ArrayList();
        }
        JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
        if (index < 0 || index >= this.fromHeaders.size()) {
            this._visitables.get((Object)"fromHeaders").add(builder);
            this.fromHeaders.add(builder);
        } else {
            this._visitables.get((Object)"fromHeaders").add(index, builder);
            this.fromHeaders.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToFromHeaders(int index, JWTHeader item) {
        if (this.fromHeaders == null) {
            this.fromHeaders = new ArrayList();
        }
        JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
        if (index < 0 || index >= this.fromHeaders.size()) {
            this._visitables.get((Object)"fromHeaders").add(builder);
            this.fromHeaders.add(builder);
        } else {
            this._visitables.get((Object)"fromHeaders").set(index, builder);
            this.fromHeaders.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToFromHeaders(JWTHeader ... items) {
        if (this.fromHeaders == null) {
            this.fromHeaders = new ArrayList();
        }
        for (JWTHeader item : items) {
            JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
            this._visitables.get((Object)"fromHeaders").add(builder);
            this.fromHeaders.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToFromHeaders(Collection<JWTHeader> items) {
        if (this.fromHeaders == null) {
            this.fromHeaders = new ArrayList();
        }
        for (JWTHeader item : items) {
            JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
            this._visitables.get((Object)"fromHeaders").add(builder);
            this.fromHeaders.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromFromHeaders(JWTHeader ... items) {
        if (this.fromHeaders == null) {
            return (A)((Object)this);
        }
        for (JWTHeader item : items) {
            JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
            this._visitables.get((Object)"fromHeaders").remove((Object)builder);
            this.fromHeaders.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFromHeaders(Collection<JWTHeader> items) {
        if (this.fromHeaders == null) {
            return (A)((Object)this);
        }
        for (JWTHeader item : items) {
            JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
            this._visitables.get((Object)"fromHeaders").remove((Object)builder);
            this.fromHeaders.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFromHeaders(Predicate<JWTHeaderBuilder> predicate) {
        if (this.fromHeaders == null) {
            return (A)((Object)this);
        }
        Iterator<JWTHeaderBuilder> each = this.fromHeaders.iterator();
        List visitables = this._visitables.get((Object)"fromHeaders");
        while (each.hasNext()) {
            JWTHeaderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<JWTHeader> buildFromHeaders() {
        return this.fromHeaders != null ? JWTRuleFluent.build(this.fromHeaders) : null;
    }

    public JWTHeader buildFromHeader(int index) {
        return this.fromHeaders.get(index).build();
    }

    public JWTHeader buildFirstFromHeader() {
        return this.fromHeaders.get(0).build();
    }

    public JWTHeader buildLastFromHeader() {
        return this.fromHeaders.get(this.fromHeaders.size() - 1).build();
    }

    public JWTHeader buildMatchingFromHeader(Predicate<JWTHeaderBuilder> predicate) {
        for (JWTHeaderBuilder item : this.fromHeaders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFromHeader(Predicate<JWTHeaderBuilder> predicate) {
        for (JWTHeaderBuilder item : this.fromHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFromHeaders(List<JWTHeader> fromHeaders) {
        if (this.fromHeaders != null) {
            this._visitables.get((Object)"fromHeaders").clear();
        }
        if (fromHeaders != null) {
            this.fromHeaders = new ArrayList();
            for (JWTHeader item : fromHeaders) {
                this.addToFromHeaders(item);
            }
        } else {
            this.fromHeaders = null;
        }
        return (A)((Object)this);
    }

    public A withFromHeaders(JWTHeader ... fromHeaders) {
        if (this.fromHeaders != null) {
            this.fromHeaders.clear();
            this._visitables.remove((Object)"fromHeaders");
        }
        if (fromHeaders != null) {
            for (JWTHeader item : fromHeaders) {
                this.addToFromHeaders(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFromHeaders() {
        return this.fromHeaders != null && !this.fromHeaders.isEmpty();
    }

    public A addNewFromHeader(String name, String prefix) {
        return this.addToFromHeaders(new JWTHeader(name, prefix));
    }

    public FromHeadersNested<A> addNewFromHeader() {
        return new FromHeadersNested(-1, null);
    }

    public FromHeadersNested<A> addNewFromHeaderLike(JWTHeader item) {
        return new FromHeadersNested(-1, item);
    }

    public FromHeadersNested<A> setNewFromHeaderLike(int index, JWTHeader item) {
        return new FromHeadersNested(index, item);
    }

    public FromHeadersNested<A> editFromHeader(int index) {
        if (this.fromHeaders.size() <= index) {
            throw new RuntimeException("Can't edit fromHeaders. Index exceeds size.");
        }
        return this.setNewFromHeaderLike(index, this.buildFromHeader(index));
    }

    public FromHeadersNested<A> editFirstFromHeader() {
        if (this.fromHeaders.size() == 0) {
            throw new RuntimeException("Can't edit first fromHeaders. The list is empty.");
        }
        return this.setNewFromHeaderLike(0, this.buildFromHeader(0));
    }

    public FromHeadersNested<A> editLastFromHeader() {
        int index = this.fromHeaders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last fromHeaders. The list is empty.");
        }
        return this.setNewFromHeaderLike(index, this.buildFromHeader(index));
    }

    public FromHeadersNested<A> editMatchingFromHeader(Predicate<JWTHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.fromHeaders.size(); ++i) {
            if (!predicate.test(this.fromHeaders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching fromHeaders. No match found.");
        }
        return this.setNewFromHeaderLike(index, this.buildFromHeader(index));
    }

    public A addToFromParams(int index, String item) {
        if (this.fromParams == null) {
            this.fromParams = new ArrayList<String>();
        }
        this.fromParams.add(index, item);
        return (A)((Object)this);
    }

    public A setToFromParams(int index, String item) {
        if (this.fromParams == null) {
            this.fromParams = new ArrayList<String>();
        }
        this.fromParams.set(index, item);
        return (A)((Object)this);
    }

    public A addToFromParams(String ... items) {
        if (this.fromParams == null) {
            this.fromParams = new ArrayList<String>();
        }
        for (String item : items) {
            this.fromParams.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToFromParams(Collection<String> items) {
        if (this.fromParams == null) {
            this.fromParams = new ArrayList<String>();
        }
        for (String item : items) {
            this.fromParams.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromFromParams(String ... items) {
        if (this.fromParams == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.fromParams.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFromParams(Collection<String> items) {
        if (this.fromParams == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.fromParams.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getFromParams() {
        return this.fromParams;
    }

    public String getFromParam(int index) {
        return this.fromParams.get(index);
    }

    public String getFirstFromParam() {
        return this.fromParams.get(0);
    }

    public String getLastFromParam() {
        return this.fromParams.get(this.fromParams.size() - 1);
    }

    public String getMatchingFromParam(Predicate<String> predicate) {
        for (String item : this.fromParams) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingFromParam(Predicate<String> predicate) {
        for (String item : this.fromParams) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFromParams(List<String> fromParams) {
        if (fromParams != null) {
            this.fromParams = new ArrayList<String>();
            for (String item : fromParams) {
                this.addToFromParams(item);
            }
        } else {
            this.fromParams = null;
        }
        return (A)((Object)this);
    }

    public A withFromParams(String ... fromParams) {
        if (this.fromParams != null) {
            this.fromParams.clear();
            this._visitables.remove((Object)"fromParams");
        }
        if (fromParams != null) {
            for (String item : fromParams) {
                this.addToFromParams(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFromParams() {
        return this.fromParams != null && !this.fromParams.isEmpty();
    }

    public String getIssuer() {
        return this.issuer;
    }

    public A withIssuer(String issuer) {
        this.issuer = issuer;
        return (A)((Object)this);
    }

    public boolean hasIssuer() {
        return this.issuer != null;
    }

    public String getJwks() {
        return this.jwks;
    }

    public A withJwks(String jwks) {
        this.jwks = jwks;
        return (A)((Object)this);
    }

    public boolean hasJwks() {
        return this.jwks != null;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public A withJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return (A)((Object)this);
    }

    public boolean hasJwksUri() {
        return this.jwksUri != null;
    }

    public String getOutputPayloadToHeader() {
        return this.outputPayloadToHeader;
    }

    public A withOutputPayloadToHeader(String outputPayloadToHeader) {
        this.outputPayloadToHeader = outputPayloadToHeader;
        return (A)((Object)this);
    }

    public boolean hasOutputPayloadToHeader() {
        return this.outputPayloadToHeader != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JWTRuleFluent that = (JWTRuleFluent)((Object)o);
        if (!Objects.equals(this.audiences, that.audiences)) {
            return false;
        }
        if (!Objects.equals(this.forwardOriginalToken, that.forwardOriginalToken)) {
            return false;
        }
        if (!Objects.equals(this.fromHeaders, that.fromHeaders)) {
            return false;
        }
        if (!Objects.equals(this.fromParams, that.fromParams)) {
            return false;
        }
        if (!Objects.equals(this.issuer, that.issuer)) {
            return false;
        }
        if (!Objects.equals(this.jwks, that.jwks)) {
            return false;
        }
        if (!Objects.equals(this.jwksUri, that.jwksUri)) {
            return false;
        }
        if (!Objects.equals(this.outputPayloadToHeader, that.outputPayloadToHeader)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.forwardOriginalToken, this.fromHeaders, this.fromParams, this.issuer, this.jwks, this.jwksUri, this.outputPayloadToHeader, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.audiences != null && !this.audiences.isEmpty()) {
            sb.append("audiences:");
            sb.append(this.audiences + ",");
        }
        if (this.forwardOriginalToken != null) {
            sb.append("forwardOriginalToken:");
            sb.append(this.forwardOriginalToken + ",");
        }
        if (this.fromHeaders != null && !this.fromHeaders.isEmpty()) {
            sb.append("fromHeaders:");
            sb.append(this.fromHeaders + ",");
        }
        if (this.fromParams != null && !this.fromParams.isEmpty()) {
            sb.append("fromParams:");
            sb.append(this.fromParams + ",");
        }
        if (this.issuer != null) {
            sb.append("issuer:");
            sb.append(this.issuer + ",");
        }
        if (this.jwks != null) {
            sb.append("jwks:");
            sb.append(this.jwks + ",");
        }
        if (this.jwksUri != null) {
            sb.append("jwksUri:");
            sb.append(this.jwksUri + ",");
        }
        if (this.outputPayloadToHeader != null) {
            sb.append("outputPayloadToHeader:");
            sb.append(this.outputPayloadToHeader + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withForwardOriginalToken() {
        return this.withForwardOriginalToken(true);
    }

    public class FromHeadersNested<N>
    extends JWTHeaderFluent<FromHeadersNested<N>>
    implements Nested<N> {
        JWTHeaderBuilder builder;
        int index;

        FromHeadersNested(int index, JWTHeader item) {
            this.index = index;
            this.builder = new JWTHeaderBuilder(this, item);
        }

        public N and() {
            return (N)JWTRuleFluent.this.setToFromHeaders(this.index, this.builder.build());
        }

        public N endFromHeader() {
            return this.and();
        }
    }
}

