/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import io.fabric8.knative.serving.v1.RouteStatus;
import io.fabric8.knative.serving.v1.RouteStatusFluent;
import io.fabric8.knative.serving.v1.TrafficTarget;
import io.fabric8.knative.serving.v1.TrafficTargetBuilder;
import io.fabric8.knative.serving.v1.TrafficTargetFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteStatusFluentImpl<A extends RouteStatusFluent<A>>
extends BaseFluent<A>
implements RouteStatusFluent<A> {
    private AddressableBuilder address;
    private Map<String, String> annotations;
    private List<ConditionBuilder> conditions;
    private Long observedGeneration;
    private List<TrafficTargetBuilder> traffic;
    private String url;

    public RouteStatusFluentImpl() {
    }

    public RouteStatusFluentImpl(RouteStatus instance) {
        this.withAddress(instance.getAddress());
        this.withAnnotations(instance.getAnnotations());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withTraffic(instance.getTraffic());
        this.withUrl(instance.getUrl());
    }

    @Override
    @Deprecated
    public Addressable getAddress() {
        return this.address != null ? this.address.build() : null;
    }

    @Override
    public Addressable buildAddress() {
        return this.address != null ? this.address.build() : null;
    }

    @Override
    public A withAddress(Addressable address) {
        this._visitables.get((Object)"address").remove(this.address);
        if (address != null) {
            this.address = new AddressableBuilder(address);
            this._visitables.get((Object)"address").add(this.address);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public A withNewAddress(String url) {
        return this.withAddress(new Addressable(url));
    }

    @Override
    public RouteStatusFluent.AddressNested<A> withNewAddress() {
        return new AddressNestedImpl();
    }

    @Override
    public RouteStatusFluent.AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNestedImpl(item);
    }

    @Override
    public RouteStatusFluent.AddressNested<A> editAddress() {
        return this.withNewAddressLike(this.getAddress());
    }

    @Override
    public RouteStatusFluent.AddressNested<A> editOrNewAddress() {
        return this.withNewAddressLike(this.getAddress() != null ? this.getAddress() : new AddressableBuilder().build());
    }

    @Override
    public RouteStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item) {
        return this.withNewAddressLike(this.getAddress() != null ? this.getAddress() : item);
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        this._visitables.get((Object)"conditions").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"conditions").size()) {
            this._visitables.get((Object)"conditions").add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Condition> getConditions() {
        return RouteStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<Condition> buildConditions() {
        return RouteStatusFluentImpl.build(this.conditions);
    }

    @Override
    public Condition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<ConditionBuilder>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public RouteStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public RouteStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public RouteStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public RouteStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public RouteStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public RouteStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public RouteStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public A addToTraffic(Integer index, TrafficTarget item) {
        if (this.traffic == null) {
            this.traffic = new ArrayList<TrafficTargetBuilder>();
        }
        TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
        this._visitables.get((Object)"traffic").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"traffic").size(), builder);
        this.traffic.add(index >= 0 ? index.intValue() : this.traffic.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTraffic(Integer index, TrafficTarget item) {
        if (this.traffic == null) {
            this.traffic = new ArrayList<TrafficTargetBuilder>();
        }
        TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"traffic").size()) {
            this._visitables.get((Object)"traffic").add(builder);
        } else {
            this._visitables.get((Object)"traffic").set(index, builder);
        }
        if (index < 0 || index >= this.traffic.size()) {
            this.traffic.add(builder);
        } else {
            this.traffic.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTraffic(TrafficTarget ... items) {
        if (this.traffic == null) {
            this.traffic = new ArrayList<TrafficTargetBuilder>();
        }
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTraffic(Collection<TrafficTarget> items) {
        if (this.traffic == null) {
            this.traffic = new ArrayList<TrafficTargetBuilder>();
        }
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTraffic(TrafficTarget ... items) {
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").remove(builder);
            if (this.traffic == null) continue;
            this.traffic.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTraffic(Collection<TrafficTarget> items) {
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").remove(builder);
            if (this.traffic == null) continue;
            this.traffic.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTraffic(Predicate<TrafficTargetBuilder> predicate) {
        if (this.traffic == null) {
            return (A)this;
        }
        Iterator<TrafficTargetBuilder> each = this.traffic.iterator();
        List visitables = this._visitables.get((Object)"traffic");
        while (each.hasNext()) {
            TrafficTargetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TrafficTarget> getTraffic() {
        return RouteStatusFluentImpl.build(this.traffic);
    }

    @Override
    public List<TrafficTarget> buildTraffic() {
        return RouteStatusFluentImpl.build(this.traffic);
    }

    @Override
    public TrafficTarget buildTraffic(Integer index) {
        return this.traffic.get(index).build();
    }

    @Override
    public TrafficTarget buildFirstTraffic() {
        return this.traffic.get(0).build();
    }

    @Override
    public TrafficTarget buildLastTraffic() {
        return this.traffic.get(this.traffic.size() - 1).build();
    }

    @Override
    public TrafficTarget buildMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        for (TrafficTargetBuilder item : this.traffic) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        for (TrafficTargetBuilder item : this.traffic) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTraffic(List<TrafficTarget> traffic) {
        if (this.traffic != null) {
            this._visitables.get((Object)"traffic").removeAll(this.traffic);
        }
        if (traffic != null) {
            this.traffic = new ArrayList<TrafficTargetBuilder>();
            for (TrafficTarget item : traffic) {
                this.addToTraffic(item);
            }
        } else {
            this.traffic = null;
        }
        return (A)this;
    }

    @Override
    public A withTraffic(TrafficTarget ... traffic) {
        if (this.traffic != null) {
            this.traffic.clear();
        }
        if (traffic != null) {
            for (TrafficTarget item : traffic) {
                this.addToTraffic(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTraffic() {
        return this.traffic != null && !this.traffic.isEmpty();
    }

    @Override
    public RouteStatusFluent.TrafficNested<A> addNewTraffic() {
        return new TrafficNestedImpl();
    }

    @Override
    public RouteStatusFluent.TrafficNested<A> addNewTrafficLike(TrafficTarget item) {
        return new TrafficNestedImpl(-1, item);
    }

    @Override
    public RouteStatusFluent.TrafficNested<A> setNewTrafficLike(Integer index, TrafficTarget item) {
        return new TrafficNestedImpl(index, item);
    }

    @Override
    public RouteStatusFluent.TrafficNested<A> editTraffic(Integer index) {
        if (this.traffic.size() <= index) {
            throw new RuntimeException("Can't edit traffic. Index exceeds size.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    @Override
    public RouteStatusFluent.TrafficNested<A> editFirstTraffic() {
        if (this.traffic.size() == 0) {
            throw new RuntimeException("Can't edit first traffic. The list is empty.");
        }
        return this.setNewTrafficLike(0, this.buildTraffic(0));
    }

    @Override
    public RouteStatusFluent.TrafficNested<A> editLastTraffic() {
        int index = this.traffic.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last traffic. The list is empty.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    @Override
    public RouteStatusFluent.TrafficNested<A> editMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.traffic.size(); ++i) {
            if (!predicate.test(this.traffic.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching traffic. No match found.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    @Override
    @Deprecated
    public A withNewUrl(String arg0) {
        return this.withUrl(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteStatusFluentImpl that = (RouteStatusFluentImpl)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.traffic != null ? !this.traffic.equals(that.traffic) : that.traffic != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.annotations, this.conditions, this.observedGeneration, this.traffic, this.url, super.hashCode());
    }

    public class TrafficNestedImpl<N>
    extends TrafficTargetFluentImpl<RouteStatusFluent.TrafficNested<N>>
    implements RouteStatusFluent.TrafficNested<N>,
    Nested<N> {
        TrafficTargetBuilder builder;
        Integer index;

        TrafficNestedImpl(Integer index, TrafficTarget item) {
            this.index = index;
            this.builder = new TrafficTargetBuilder(this, item);
        }

        TrafficNestedImpl() {
            this.index = -1;
            this.builder = new TrafficTargetBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteStatusFluentImpl.this.setToTraffic(this.index, this.builder.build());
        }

        @Override
        public N endTraffic() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends ConditionFluentImpl<RouteStatusFluent.ConditionsNested<N>>
    implements RouteStatusFluent.ConditionsNested<N>,
    Nested<N> {
        ConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    public class AddressNestedImpl<N>
    extends AddressableFluentImpl<RouteStatusFluent.AddressNested<N>>
    implements RouteStatusFluent.AddressNested<N>,
    Nested<N> {
        AddressableBuilder builder;

        AddressNestedImpl(Addressable item) {
            this.builder = new AddressableBuilder(this, item);
        }

        AddressNestedImpl() {
            this.builder = new AddressableBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteStatusFluentImpl.this.withAddress(this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

