
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacity;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityBuilder;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityList;

import java.util.Map;
import java.util.TreeMap;


public class CSIStorageCapacityOperationsImpl extends HasMetadataOperation<CSIStorageCapacity, CSIStorageCapacityList, Resource<CSIStorageCapacity>> {

  public CSIStorageCapacityOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public CSIStorageCapacityOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public CSIStorageCapacityOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("storage.k8s.io")
    .withApiGroupVersion("v1beta1")
    .withPlural("csistoragecapacities"));
    this.type = CSIStorageCapacity.class;
    this.listType = CSIStorageCapacityList.class;
  }

  public CSIStorageCapacityOperationsImpl newInstance(OperationContext context) {
    return new CSIStorageCapacityOperationsImpl(context);
  }

  @Override
  public CSIStorageCapacity edit(Visitor... visitors) {
    return patch(new CSIStorageCapacityBuilder(getMandatory()).accept(visitors).build());
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
