
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.ReplicationControllerOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;

public class ReplicationControllerHandler implements ResourceHandler<ReplicationController, ReplicationControllerBuilder> {

  @Override
  public String getKind() {
    return ReplicationController.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public ReplicationControllerBuilder edit(ReplicationController item) {
    return new ReplicationControllerBuilder(item);
  }

  @Override
  public Resource<ReplicationController> resource(OkHttpClient client, Config config, String namespace, ReplicationController item) {
    return new ReplicationControllerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
