
                                          

package io.fabric8.kubernetes.client.handlers.flowcontrol.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.flowcontrol.v1beta1.PriorityLevelConfigurationOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PriorityLevelConfiguration;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PriorityLevelConfigurationBuilder;

public class PriorityLevelConfigurationHandler implements ResourceHandler<PriorityLevelConfiguration, PriorityLevelConfigurationBuilder> {

  @Override
  public String getKind() {
    return PriorityLevelConfiguration.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "flowcontrol.apiserver.k8s.io/v1beta1";
      }

  @Override
  public PriorityLevelConfigurationBuilder edit(PriorityLevelConfiguration item) {
    return new PriorityLevelConfigurationBuilder(item);
  }

  @Override
  public Resource<PriorityLevelConfiguration> resource(OkHttpClient client, Config config, String namespace, PriorityLevelConfiguration item) {
    return new PriorityLevelConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
