
                                          

package io.fabric8.kubernetes.client.handlers.storage.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.storage.v1beta1.CSIDriverOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriver;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverBuilder;

public class CSIDriverHandler implements ResourceHandler<CSIDriver, CSIDriverBuilder> {

  @Override
  public String getKind() {
    return CSIDriver.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "storage.k8s.io/v1beta1";
      }

  @Override
  public CSIDriverBuilder edit(CSIDriver item) {
    return new CSIDriverBuilder(item);
  }

  @Override
  public Resource<CSIDriver> resource(OkHttpClient client, Config config, String namespace, CSIDriver item) {
    return new CSIDriverOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
