
                                          

package io.fabric8.kubernetes.client.handlers.storage.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.storage.v1beta1.CSIStorageCapacityOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacity;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIStorageCapacityBuilder;

public class CSIStorageCapacityHandler implements ResourceHandler<CSIStorageCapacity, CSIStorageCapacityBuilder> {

  @Override
  public String getKind() {
    return CSIStorageCapacity.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "storage.k8s.io/v1beta1";
      }

  @Override
  public CSIStorageCapacityBuilder edit(CSIStorageCapacity item) {
    return new CSIStorageCapacityBuilder(item);
  }

  @Override
  public Resource<CSIStorageCapacity> resource(OkHttpClient client, Config config, String namespace, CSIStorageCapacity item) {
    return new CSIStorageCapacityOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
