/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.WatchAndWaitable;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.examples.crds.Dummy;
import io.fabric8.kubernetes.examples.crds.DummyList;
import io.fabric8.kubernetes.examples.crds.DummySpec;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRDExample {
    private static final Logger logger = LoggerFactory.getLogger(CRDExample.class);
    private static boolean logRootPaths = false;

    public static void main(String[] args) {
        boolean resourceNamespaced = true;
        String namespace = null;
        if (args.length > 0) {
            if ("--cluster".equals(args[0])) {
                resourceNamespaced = false;
            } else {
                namespace = args[0];
            }
        }
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            List paths;
            RootPaths rootPaths;
            if (resourceNamespaced) {
                if (namespace == null) {
                    namespace = client.getNamespace();
                }
                if (namespace == null) {
                    System.err.println("No namespace specified and no default defined!");
                    return;
                }
                System.out.println("Using namespace: " + namespace);
            } else {
                System.out.println("Creating cluster scoped resource");
            }
            if (logRootPaths && (rootPaths = client.rootPaths()) != null && (paths = rootPaths.getPaths()) != null) {
                System.out.println("Supported API Paths:");
                for (String path : paths) {
                    System.out.println("    " + path);
                }
                System.out.println();
            }
            CustomResourceDefinitionList crds = (CustomResourceDefinitionList)client.apiextensions().v1beta1().customResourceDefinitions().list();
            List crdsItems = crds.getItems();
            System.out.println("Found " + crdsItems.size() + " CRD(s)");
            CustomResourceDefinition dummyCRD = null;
            String dummyCRDName = CustomResource.getCRDName(Dummy.class);
            for (CustomResourceDefinition crd : crdsItems) {
                ObjectMeta metadata = crd.getMetadata();
                if (metadata == null) continue;
                String name = metadata.getName();
                System.out.println("    " + (String)name + " => " + metadata.getSelfLink());
                if (!dummyCRDName.equals(name)) continue;
                dummyCRD = crd;
            }
            if (dummyCRD != null) {
                System.out.println("Found CRD: " + dummyCRD.getMetadata().getSelfLink());
            } else {
                dummyCRD = CustomResourceDefinitionContext.v1beta1CRDFromCustomResourceType(Dummy.class).build();
                client.apiextensions().v1beta1().customResourceDefinitions().create((Object)dummyCRD);
                System.out.println("Created CRD " + dummyCRD.getMetadata().getName());
            }
            KubernetesDeserializer.registerCustomKind((String)HasMetadata.getApiVersion(Dummy.class), (String)dummyCRD.getKind(), Dummy.class);
            MixedOperation dummyClient = client.customResources(Dummy.class, DummyList.class);
            if (resourceNamespaced) {
                dummyClient = (NonNamespaceOperation)dummyClient.inNamespace(namespace);
            }
            CustomResourceList dummyList = (CustomResourceList)dummyClient.list();
            List items = dummyList.getItems();
            System.out.println("  found " + items.size() + " dummies");
            for (Dummy item : items) {
                System.out.println("    " + (Object)((Object)item));
            }
            Dummy dummy = new Dummy();
            ObjectMeta metadata = new ObjectMeta();
            metadata.setName("foo");
            dummy.setMetadata(metadata);
            DummySpec dummySpec = new DummySpec();
            Date now = new Date();
            dummySpec.setBar("beer: " + now);
            dummySpec.setFoo("cheese: " + now);
            dummy.setSpec(dummySpec);
            Dummy created = (Dummy)((Object)dummyClient.createOrReplace((Object[])new Dummy[]{dummy}));
            System.out.println("Upserted " + (Object)((Object)dummy));
            ((DummySpec)created.getSpec()).setBar("otherBar");
            dummyClient.createOrReplace((Object[])new Dummy[]{created});
            System.out.println("Watching for changes to Dummies");
            ((WatchAndWaitable)dummyClient.withResourceVersion(created.getMetadata().getResourceVersion())).watch((Object)new Watcher<Dummy>(){

                public void eventReceived(Watcher.Action action, Dummy resource) {
                    System.out.println("==> " + action + " for " + (Object)((Object)resource));
                    if (resource.getSpec() == null) {
                        logger.error("No Spec for resource {}", (Object)resource);
                    }
                }

                public void onClose(WatcherException cause) {
                }
            });
            System.in.read();
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

