/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigBuilder;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.ConfigMapLock;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaseLock;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;

public class LeaderElectionExamples {
    private static final String NAMESPACE = "default";
    private static final String NAME = "leaders-of-the-future";

    public static final class ConcurrentExample {
        private static final int THREAD_COUNT = 100;
        private static final int THREADS_TO_KILL = 5;
        private static final long WAIT_TO_KILL_TIME = 2500L;
        private static final long TASK_SLEEP = 50L;
        private static final int TASK_THREADS = 2;
        private final KubernetesClient kubernetesClient;
        private final Function<String, Lock> lockSupplier;
        private final Class<? extends Lock> lockClass;
        private final AtomicReference<String> leaderReference;
        private final Map<String, Future<?>> leaderCandidates;
        private final ScheduledThreadPoolExecutor executorService;

        public ConcurrentExample(KubernetesClient kubernetesClient, Function<String, Lock> lockSupplier) {
            this.kubernetesClient = kubernetesClient;
            this.lockSupplier = lockSupplier;
            this.lockClass = lockSupplier.apply("GET LOCK INFO ONLY").getClass();
            this.leaderReference = new AtomicReference<Object>(null);
            this.leaderCandidates = new ConcurrentHashMap();
            this.executorService = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(102);
        }

        public static void main(String[] args) throws Exception {
            try (DefaultKubernetesClient kc = new DefaultKubernetesClient();){
                Function<String, Lock> lockSupplier;
                String lockArgument;
                switch (lockArgument = args.length > 0 ? args[0] : "") {
                    case "lease": {
                        lockSupplier = id -> new LeaseLock(LeaderElectionExamples.NAMESPACE, LeaderElectionExamples.NAME, id);
                        break;
                    }
                    default: {
                        lockSupplier = id -> new ConfigMapLock(LeaderElectionExamples.NAMESPACE, LeaderElectionExamples.NAME, id);
                    }
                }
                new ConcurrentExample((KubernetesClient)kc, lockSupplier).run();
            }
        }

        private void run() throws Exception {
            Future<?> monitor = this.monitor();
            this.spawn();
            CountDownLatch countDownLatch = new CountDownLatch(5);
            Future<?> killLeaders = this.killLeaders(countDownLatch);
            if (!countDownLatch.await(120L, TimeUnit.SECONDS)) {
                System.err.println("\rTimeout reached, demo did not complete successfully");
            }
            this.tearDown(monitor, killLeaders);
        }

        private Future<?> monitor() {
            return this.executorService.scheduleWithFixedDelay(() -> {
                String currentLeader = this.leaderReference.get();
                System.out.printf("\rActive Threads: %s \tCurrent leader: %s", this.leaderCandidates.size(), Optional.ofNullable(currentLeader).orElse(""));
            }, 0L, 50L, TimeUnit.MILLISECONDS);
        }

        private void spawn() {
            System.out.printf("Spawning %s identical threads with leader election algorithm and lock (%s)%n", 100, this.lockClass.getSimpleName());
            for (int it = 0; it < 100; ++it) {
                String id = String.format("Concurrent-%s", it);
                this.leaderCandidates.put(id, this.executorService.schedule(this.leader(id, this.lockSupplier), (long)it * 30L, TimeUnit.MILLISECONDS));
            }
        }

        private Future<?> killLeaders(CountDownLatch leadersToKillCountDown) {
            System.out.printf("\rSpawning thread to kill %s leader candidates %s millis after they become leaders%n", 5, 2500L);
            return this.executorService.scheduleWithFixedDelay(() -> {
                String currentLeader = this.leaderReference.get();
                Optional.ofNullable(currentLeader).map(this.leaderCandidates::get).ifPresent(leader -> {
                    try {
                        Thread.sleep(2500L);
                        leader.cancel(true);
                        this.leaderCandidates.remove(currentLeader);
                        leadersToKillCountDown.countDown();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                });
            }, 0L, 50L, TimeUnit.MILLISECONDS);
        }

        private void tearDown(Future<?> ... futures) throws Exception {
            Thread.sleep(51L);
            System.out.println("\rDemo completed!");
            System.out.printf("\rTearing down rest of the leader candidates (%s) and task threads (%s)%n", this.leaderCandidates.size(), futures.length);
            Stream.concat(Stream.of(futures), this.leaderCandidates.values().stream()).forEach(f -> f.cancel(true));
            this.leaderCandidates.clear();
            this.executorService.shutdownNow();
            System.out.println("\rAll threads scheduled to cancel, shutting down.");
            this.kubernetesClient.close();
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }

        private Runnable leader(String id, Function<String, Lock> lockSupplier) {
            return () -> this.kubernetesClient.leaderElector().withConfig(((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)new LeaderElectionConfigBuilder().withName("Concurrent Leader Election configuration")).withLeaseDuration(Duration.ofMillis(2000L))).withLock((Lock)lockSupplier.apply(id))).withRenewDeadline(Duration.ofMillis(1500L))).withRetryPeriod(Duration.ofMillis(300L))).withLeaderCallbacks(new LeaderCallbacks(() -> System.out.printf("\r%1$s: I just became leader!!!%n", id), () -> {
                this.leaderReference.set(null);
                System.out.printf("\r%1$s: I just lost my leadership :(%n", id);
            }, this.leaderReference::set))).build()).build().run();
        }

        static {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "off");
        }
    }

    public static final class SingleThreadExample {
        public static void main(String[] args) {
            String lockIdentity = UUID.randomUUID().toString();
            try (DefaultKubernetesClient kc = new DefaultKubernetesClient();){
                kc.leaderElector().withConfig(((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)new LeaderElectionConfigBuilder().withName("Sample Leader Election configuration")).withLeaseDuration(Duration.ofSeconds(15L))).withLock((Lock)new LeaseLock(LeaderElectionExamples.NAMESPACE, LeaderElectionExamples.NAME, lockIdentity))).withRenewDeadline(Duration.ofSeconds(10L))).withRetryPeriod(Duration.ofSeconds(2L))).withLeaderCallbacks(new LeaderCallbacks(() -> System.out.println("STARTED LEADERSHIP"), () -> System.out.println("STOPPED LEADERSHIP"), newLeader -> System.out.printf("New leader elected %s%n", newLeader)))).build()).build().run();
            }
        }
    }
}

