package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MutatingWebhookConfigurationListBuilder extends MutatingWebhookConfigurationListFluentImpl<MutatingWebhookConfigurationListBuilder> implements VisitableBuilder<MutatingWebhookConfigurationList,MutatingWebhookConfigurationListBuilder>{
  public MutatingWebhookConfigurationListBuilder() {
    this(false);
  }
  public MutatingWebhookConfigurationListBuilder(Boolean validationEnabled) {
    this(new MutatingWebhookConfigurationList(), validationEnabled);
  }
  public MutatingWebhookConfigurationListBuilder(MutatingWebhookConfigurationListFluent<?> fluent) {
    this(fluent, false);
  }
  public MutatingWebhookConfigurationListBuilder(MutatingWebhookConfigurationListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MutatingWebhookConfigurationList(), validationEnabled);
  }
  public MutatingWebhookConfigurationListBuilder(MutatingWebhookConfigurationListFluent<?> fluent,MutatingWebhookConfigurationList instance) {
    this(fluent, instance, false);
  }
  public MutatingWebhookConfigurationListBuilder(MutatingWebhookConfigurationListFluent<?> fluent,MutatingWebhookConfigurationList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MutatingWebhookConfigurationListBuilder(MutatingWebhookConfigurationList instance) {
    this(instance,false);
  }
  public MutatingWebhookConfigurationListBuilder(MutatingWebhookConfigurationList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MutatingWebhookConfigurationListFluent<?> fluent;
  Boolean validationEnabled;
  public MutatingWebhookConfigurationList build() {
    MutatingWebhookConfigurationList buildable = new MutatingWebhookConfigurationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}