package io.fabric8.kubernetes.api.model.authentication;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TokenReviewFluentImpl<A extends TokenReviewFluent<A>> extends BaseFluent<A> implements TokenReviewFluent<A>{
  public TokenReviewFluentImpl() {
  }
  public TokenReviewFluentImpl(TokenReview instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private TokenReviewSpecBuilder spec;
  private TokenReviewStatusBuilder status;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public TokenReviewFluent.MetadataNested<A> withNewMetadata() {
    return new TokenReviewFluentImpl.MetadataNestedImpl();
  }
  public TokenReviewFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new TokenReviewFluentImpl.MetadataNestedImpl(item);
  }
  public TokenReviewFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public TokenReviewFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public TokenReviewFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public TokenReviewSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public TokenReviewSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(TokenReviewSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new TokenReviewSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public TokenReviewFluent.SpecNested<A> withNewSpec() {
    return new TokenReviewFluentImpl.SpecNestedImpl();
  }
  public TokenReviewFluent.SpecNested<A> withNewSpecLike(TokenReviewSpec item) {
    return new TokenReviewFluentImpl.SpecNestedImpl(item);
  }
  public TokenReviewFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public TokenReviewFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new TokenReviewSpecBuilder().build());
  }
  public TokenReviewFluent.SpecNested<A> editOrNewSpecLike(TokenReviewSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public TokenReviewStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public TokenReviewStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(TokenReviewStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new TokenReviewStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public TokenReviewFluent.StatusNested<A> withNewStatus() {
    return new TokenReviewFluentImpl.StatusNestedImpl();
  }
  public TokenReviewFluent.StatusNested<A> withNewStatusLike(TokenReviewStatus item) {
    return new TokenReviewFluentImpl.StatusNestedImpl(item);
  }
  public TokenReviewFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public TokenReviewFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new TokenReviewStatusBuilder().build());
  }
  public TokenReviewFluent.StatusNested<A> editOrNewStatusLike(TokenReviewStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TokenReviewFluentImpl that = (TokenReviewFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<TokenReviewFluent.MetadataNested<N>> implements TokenReviewFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) TokenReviewFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends TokenReviewSpecFluentImpl<TokenReviewFluent.SpecNested<N>> implements TokenReviewFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(TokenReviewSpec item) {
      this.builder = new TokenReviewSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new TokenReviewSpecBuilder(this);
    }
    TokenReviewSpecBuilder builder;
    public N and() {
      return (N) TokenReviewFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends TokenReviewStatusFluentImpl<TokenReviewFluent.StatusNested<N>> implements TokenReviewFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(TokenReviewStatus item) {
      this.builder = new TokenReviewStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new TokenReviewStatusBuilder(this);
    }
    TokenReviewStatusBuilder builder;
    public N and() {
      return (N) TokenReviewFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}