package io.fabric8.kubernetes.api.model.authorization.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SelfSubjectRulesReviewFluentImpl<A extends SelfSubjectRulesReviewFluent<A>> extends BaseFluent<A> implements SelfSubjectRulesReviewFluent<A>{
  public SelfSubjectRulesReviewFluentImpl() {
  }
  public SelfSubjectRulesReviewFluentImpl(SelfSubjectRulesReview instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private SelfSubjectRulesReviewSpecBuilder spec;
  private SubjectRulesReviewStatusBuilder status;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public SelfSubjectRulesReviewFluent.MetadataNested<A> withNewMetadata() {
    return new SelfSubjectRulesReviewFluentImpl.MetadataNestedImpl();
  }
  public SelfSubjectRulesReviewFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new SelfSubjectRulesReviewFluentImpl.MetadataNestedImpl(item);
  }
  public SelfSubjectRulesReviewFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public SelfSubjectRulesReviewFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public SelfSubjectRulesReviewFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public SelfSubjectRulesReviewSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public SelfSubjectRulesReviewSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(SelfSubjectRulesReviewSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new SelfSubjectRulesReviewSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public A withNewSpec(String namespace) {
    return (A)withSpec(new SelfSubjectRulesReviewSpec(namespace));
  }
  public SelfSubjectRulesReviewFluent.SpecNested<A> withNewSpec() {
    return new SelfSubjectRulesReviewFluentImpl.SpecNestedImpl();
  }
  public SelfSubjectRulesReviewFluent.SpecNested<A> withNewSpecLike(SelfSubjectRulesReviewSpec item) {
    return new SelfSubjectRulesReviewFluentImpl.SpecNestedImpl(item);
  }
  public SelfSubjectRulesReviewFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public SelfSubjectRulesReviewFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new SelfSubjectRulesReviewSpecBuilder().build());
  }
  public SelfSubjectRulesReviewFluent.SpecNested<A> editOrNewSpecLike(SelfSubjectRulesReviewSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public SubjectRulesReviewStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public SubjectRulesReviewStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(SubjectRulesReviewStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new SubjectRulesReviewStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public SelfSubjectRulesReviewFluent.StatusNested<A> withNewStatus() {
    return new SelfSubjectRulesReviewFluentImpl.StatusNestedImpl();
  }
  public SelfSubjectRulesReviewFluent.StatusNested<A> withNewStatusLike(SubjectRulesReviewStatus item) {
    return new SelfSubjectRulesReviewFluentImpl.StatusNestedImpl(item);
  }
  public SelfSubjectRulesReviewFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public SelfSubjectRulesReviewFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new SubjectRulesReviewStatusBuilder().build());
  }
  public SelfSubjectRulesReviewFluent.StatusNested<A> editOrNewStatusLike(SubjectRulesReviewStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SelfSubjectRulesReviewFluentImpl that = (SelfSubjectRulesReviewFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<SelfSubjectRulesReviewFluent.MetadataNested<N>> implements SelfSubjectRulesReviewFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) SelfSubjectRulesReviewFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends SelfSubjectRulesReviewSpecFluentImpl<SelfSubjectRulesReviewFluent.SpecNested<N>> implements SelfSubjectRulesReviewFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(SelfSubjectRulesReviewSpec item) {
      this.builder = new SelfSubjectRulesReviewSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new SelfSubjectRulesReviewSpecBuilder(this);
    }
    SelfSubjectRulesReviewSpecBuilder builder;
    public N and() {
      return (N) SelfSubjectRulesReviewFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends SubjectRulesReviewStatusFluentImpl<SelfSubjectRulesReviewFluent.StatusNested<N>> implements SelfSubjectRulesReviewFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(SubjectRulesReviewStatus item) {
      this.builder = new SubjectRulesReviewStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new SubjectRulesReviewStatusBuilder(this);
    }
    SubjectRulesReviewStatusBuilder builder;
    public N and() {
      return (N) SelfSubjectRulesReviewFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}