package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourceMetricSourceFluentImpl<A extends ResourceMetricSourceFluent<A>> extends BaseFluent<A> implements ResourceMetricSourceFluent<A>{
  public ResourceMetricSourceFluentImpl() {
  }
  public ResourceMetricSourceFluentImpl(ResourceMetricSource instance) {
    this.withName(instance.getName()); 
    this.withTargetAverageUtilization(instance.getTargetAverageUtilization()); 
    this.withTargetAverageValue(instance.getTargetAverageValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String name;
  private Integer targetAverageUtilization;
  private Quantity targetAverageValue;
  private Map<String,Object> additionalProperties;
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public Integer getTargetAverageUtilization() {
    return this.targetAverageUtilization;
  }
  public A withTargetAverageUtilization(Integer targetAverageUtilization) {
    this.targetAverageUtilization=targetAverageUtilization; return (A) this;
  }
  public Boolean hasTargetAverageUtilization() {
    return this.targetAverageUtilization != null;
  }
  public Quantity getTargetAverageValue() {
    return this.targetAverageValue;
  }
  public A withTargetAverageValue(Quantity targetAverageValue) {
    this.targetAverageValue=targetAverageValue; return (A) this;
  }
  public Boolean hasTargetAverageValue() {
    return this.targetAverageValue != null;
  }
  public A withNewTargetAverageValue(String amount,String format) {
    return (A)withTargetAverageValue(new Quantity(amount, format));
  }
  public A withNewTargetAverageValue(String amount) {
    return (A)withTargetAverageValue(new Quantity(amount));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResourceMetricSourceFluentImpl that = (ResourceMetricSourceFluentImpl) o;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (targetAverageUtilization != null ? !targetAverageUtilization.equals(that.targetAverageUtilization) :that.targetAverageUtilization != null) return false;
    if (targetAverageValue != null ? !targetAverageValue.equals(that.targetAverageValue) :that.targetAverageValue != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(name,  targetAverageUtilization,  targetAverageValue,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (targetAverageUtilization != null) { sb.append("targetAverageUtilization:"); sb.append(targetAverageUtilization + ","); }
    if (targetAverageValue != null) { sb.append("targetAverageValue:"); sb.append(targetAverageValue + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}