package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CephFSVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.CephFSVolumeSource,io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CephFSVolumeSourceBuilder() {
        this(true);
    }

    public CephFSVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new CephFSVolumeSource(), validationEnabled);
    }

    public CephFSVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public CephFSVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CephFSVolumeSource(), validationEnabled);
    }

    public CephFSVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.CephFSVolumeSource instance) {
        this(fluent, instance, true);
    }

    public CephFSVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.CephFSVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMonitors(instance.getMonitors()); 
        fluent.withPath(instance.getPath()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withSecretFile(instance.getSecretFile()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        fluent.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public CephFSVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CephFSVolumeSource instance) {
        this(instance,true);
    }

    public CephFSVolumeSourceBuilder(io.fabric8.kubernetes.api.model.CephFSVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMonitors(instance.getMonitors()); 
        this.withPath(instance.getPath()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretFile(instance.getSecretFile()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.CephFSVolumeSource build() {
        CephFSVolumeSource buildable = new CephFSVolumeSource(fluent.getMonitors(),fluent.getPath(),fluent.getReadOnly(),fluent.getSecretFile(),fluent.getSecretRef(),fluent.getUser());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CephFSVolumeSourceBuilder that = (CephFSVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
