package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CreateOptionsBuilder extends io.fabric8.kubernetes.api.model.CreateOptionsFluentImpl<io.fabric8.kubernetes.api.model.CreateOptionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.CreateOptions,io.fabric8.kubernetes.api.model.CreateOptionsBuilder> {

    io.fabric8.kubernetes.api.model.CreateOptionsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CreateOptionsBuilder() {
        this(true);
    }

    public CreateOptionsBuilder(java.lang.Boolean validationEnabled) {
        this(new CreateOptions(), validationEnabled);
    }

    public CreateOptionsBuilder(io.fabric8.kubernetes.api.model.CreateOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public CreateOptionsBuilder(io.fabric8.kubernetes.api.model.CreateOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CreateOptions(), validationEnabled);
    }

    public CreateOptionsBuilder(io.fabric8.kubernetes.api.model.CreateOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.CreateOptions instance) {
        this(fluent, instance, true);
    }

    public CreateOptionsBuilder(io.fabric8.kubernetes.api.model.CreateOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.CreateOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withDryRun(instance.getDryRun()); 
        fluent.withFieldManager(instance.getFieldManager()); 
        fluent.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public CreateOptionsBuilder(io.fabric8.kubernetes.api.model.CreateOptions instance) {
        this(instance,true);
    }

    public CreateOptionsBuilder(io.fabric8.kubernetes.api.model.CreateOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withDryRun(instance.getDryRun()); 
        this.withFieldManager(instance.getFieldManager()); 
        this.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.CreateOptions build() {
        CreateOptions buildable = new CreateOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getFieldManager(),fluent.getKind());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CreateOptionsBuilder that = (CreateOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
