package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface EndpointSubsetFluent<A extends io.fabric8.kubernetes.api.model.EndpointSubsetFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToAddresses(int index,io.fabric8.kubernetes.api.model.EndpointAddress item);
    public A setToAddresses(int index,io.fabric8.kubernetes.api.model.EndpointAddress item);
    public A addToAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items);
    public A addAllToAddresses(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointAddress> items);
    public A removeFromAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items);
    public A removeAllFromAddresses(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointAddress> items);
    public A removeMatchingFromAddresses(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAddresses instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.EndpointAddress> getAddresses();
    public java.util.List<io.fabric8.kubernetes.api.model.EndpointAddress> buildAddresses();
    public io.fabric8.kubernetes.api.model.EndpointAddress buildAddress(int index);
    public io.fabric8.kubernetes.api.model.EndpointAddress buildFirstAddress();
    public io.fabric8.kubernetes.api.model.EndpointAddress buildLastAddress();
    public io.fabric8.kubernetes.api.model.EndpointAddress buildMatchingAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate);
    public java.lang.Boolean hasMatchingAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate);
    public A withAddresses(java.util.List<io.fabric8.kubernetes.api.model.EndpointAddress> addresses);
    public A withAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... addresses);
    public java.lang.Boolean hasAddresses();
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> addNewAddress();
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(io.fabric8.kubernetes.api.model.EndpointAddress item);
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> setNewAddressLike(int index,io.fabric8.kubernetes.api.model.EndpointAddress item);
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> editAddress(int index);
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> editFirstAddress();
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> editLastAddress();
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> editMatchingAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate);
    public A addToNotReadyAddresses(int index,io.fabric8.kubernetes.api.model.EndpointAddress item);
    public A setToNotReadyAddresses(int index,io.fabric8.kubernetes.api.model.EndpointAddress item);
    public A addToNotReadyAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items);
    public A addAllToNotReadyAddresses(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointAddress> items);
    public A removeFromNotReadyAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items);
    public A removeAllFromNotReadyAddresses(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointAddress> items);
    public A removeMatchingFromNotReadyAddresses(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildNotReadyAddresses instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.EndpointAddress> getNotReadyAddresses();
    public java.util.List<io.fabric8.kubernetes.api.model.EndpointAddress> buildNotReadyAddresses();
    public io.fabric8.kubernetes.api.model.EndpointAddress buildNotReadyAddress(int index);
    public io.fabric8.kubernetes.api.model.EndpointAddress buildFirstNotReadyAddress();
    public io.fabric8.kubernetes.api.model.EndpointAddress buildLastNotReadyAddress();
    public io.fabric8.kubernetes.api.model.EndpointAddress buildMatchingNotReadyAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate);
    public java.lang.Boolean hasMatchingNotReadyAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate);
    public A withNotReadyAddresses(java.util.List<io.fabric8.kubernetes.api.model.EndpointAddress> notReadyAddresses);
    public A withNotReadyAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... notReadyAddresses);
    public java.lang.Boolean hasNotReadyAddresses();
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress();
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(io.fabric8.kubernetes.api.model.EndpointAddress item);
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> setNewNotReadyAddressLike(int index,io.fabric8.kubernetes.api.model.EndpointAddress item);
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> editNotReadyAddress(int index);
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> editFirstNotReadyAddress();
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> editLastNotReadyAddress();
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> editMatchingNotReadyAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate);
    public A addToPorts(int index,io.fabric8.kubernetes.api.model.EndpointPort item);
    public A setToPorts(int index,io.fabric8.kubernetes.api.model.EndpointPort item);
    public A addToPorts(io.fabric8.kubernetes.api.model.EndpointPort... items);
    public A addAllToPorts(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointPort> items);
    public A removeFromPorts(io.fabric8.kubernetes.api.model.EndpointPort... items);
    public A removeAllFromPorts(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointPort> items);
    public A removeMatchingFromPorts(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointPortBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPorts instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.EndpointPort> getPorts();
    public java.util.List<io.fabric8.kubernetes.api.model.EndpointPort> buildPorts();
    public io.fabric8.kubernetes.api.model.EndpointPort buildPort(int index);
    public io.fabric8.kubernetes.api.model.EndpointPort buildFirstPort();
    public io.fabric8.kubernetes.api.model.EndpointPort buildLastPort();
    public io.fabric8.kubernetes.api.model.EndpointPort buildMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointPortBuilder> predicate);
    public java.lang.Boolean hasMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointPortBuilder> predicate);
    public A withPorts(java.util.List<io.fabric8.kubernetes.api.model.EndpointPort> ports);
    public A withPorts(io.fabric8.kubernetes.api.model.EndpointPort... ports);
    public java.lang.Boolean hasPorts();
    public A addNewPort(java.lang.String appProtocol,java.lang.String name,java.lang.Integer port,java.lang.String protocol);
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> addNewPort();
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> addNewPortLike(io.fabric8.kubernetes.api.model.EndpointPort item);
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> setNewPortLike(int index,io.fabric8.kubernetes.api.model.EndpointPort item);
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> editPort(int index);
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> editFirstPort();
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> editLastPort();
    public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> editMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointPortBuilder> predicate);
    public interface AddressesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.EndpointAddressFluent<io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<N>> {

            public N and();
            public N endAddress();    }


    public interface NotReadyAddressesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.EndpointAddressFluent<io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<N>> {

            public N and();
            public N endNotReadyAddress();    }


    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.EndpointPortFluent<io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<N>> {

            public N and();
            public N endPort();    }


}
