package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FlexPersistentVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource,io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public FlexPersistentVolumeSourceBuilder() {
        this(true);
    }

    public FlexPersistentVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new FlexPersistentVolumeSource(), validationEnabled);
    }

    public FlexPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public FlexPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new FlexPersistentVolumeSource(), validationEnabled);
    }

    public FlexPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource instance) {
        this(fluent, instance, true);
    }

    public FlexPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDriver(instance.getDriver()); 
        fluent.withFsType(instance.getFsType()); 
        fluent.withOptions(instance.getOptions()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        this.validationEnabled = validationEnabled; 
    }

    public FlexPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource instance) {
        this(instance,true);
    }

    public FlexPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDriver(instance.getDriver()); 
        this.withFsType(instance.getFsType()); 
        this.withOptions(instance.getOptions()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource build() {
        FlexPersistentVolumeSource buildable = new FlexPersistentVolumeSource(fluent.getDriver(),fluent.getFsType(),fluent.getOptions(),fluent.getReadOnly(),fluent.getSecretRef());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        FlexPersistentVolumeSourceBuilder that = (FlexPersistentVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
