package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ProjectedVolumeSourceFluentImpl<A extends io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent<A> {

    private java.lang.Integer defaultMode;
    private java.util.List<io.fabric8.kubernetes.api.model.VolumeProjectionBuilder> sources =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeProjectionBuilder>();

    public ProjectedVolumeSourceFluentImpl() {
    }

    public ProjectedVolumeSourceFluentImpl(io.fabric8.kubernetes.api.model.ProjectedVolumeSource instance) {
        this.withDefaultMode(instance.getDefaultMode()); 
        this.withSources(instance.getSources()); 
    }

    public java.lang.Integer getDefaultMode() {
        return this.defaultMode;
    }

    public A withDefaultMode(java.lang.Integer defaultMode) {
        this.defaultMode=defaultMode; return (A) this;
    }

    public java.lang.Boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    public A addToSources(int index,io.fabric8.kubernetes.api.model.VolumeProjection item) {
        if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeProjectionBuilder>();}
        io.fabric8.kubernetes.api.model.VolumeProjectionBuilder builder = new io.fabric8.kubernetes.api.model.VolumeProjectionBuilder(item);_visitables.get("sources").add(index >= 0 ? index : _visitables.get("sources").size(), builder);this.sources.add(index >= 0 ? index : sources.size(), builder); return (A)this;
    }

    public A setToSources(int index,io.fabric8.kubernetes.api.model.VolumeProjection item) {
        if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeProjectionBuilder>();}
        io.fabric8.kubernetes.api.model.VolumeProjectionBuilder builder = new io.fabric8.kubernetes.api.model.VolumeProjectionBuilder(item);
        if (index < 0 || index >= _visitables.get("sources").size()) { _visitables.get("sources").add(builder); } else { _visitables.get("sources").set(index, builder);}
        if (index < 0 || index >= sources.size()) { sources.add(builder); } else { sources.set(index, builder);}
         return (A)this;
    }

    public A addToSources(io.fabric8.kubernetes.api.model.VolumeProjection... items) {
        if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeProjectionBuilder>();}
        for (io.fabric8.kubernetes.api.model.VolumeProjection item : items) {io.fabric8.kubernetes.api.model.VolumeProjectionBuilder builder = new io.fabric8.kubernetes.api.model.VolumeProjectionBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
    }

    public A addAllToSources(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeProjection> items) {
        if (this.sources == null) {this.sources = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeProjectionBuilder>();}
        for (io.fabric8.kubernetes.api.model.VolumeProjection item : items) {io.fabric8.kubernetes.api.model.VolumeProjectionBuilder builder = new io.fabric8.kubernetes.api.model.VolumeProjectionBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
    }

    public A removeFromSources(io.fabric8.kubernetes.api.model.VolumeProjection... items) {
        for (io.fabric8.kubernetes.api.model.VolumeProjection item : items) {io.fabric8.kubernetes.api.model.VolumeProjectionBuilder builder = new io.fabric8.kubernetes.api.model.VolumeProjectionBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
    }

    public A removeAllFromSources(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeProjection> items) {
        for (io.fabric8.kubernetes.api.model.VolumeProjection item : items) {io.fabric8.kubernetes.api.model.VolumeProjectionBuilder builder = new io.fabric8.kubernetes.api.model.VolumeProjectionBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSources(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeProjectionBuilder> predicate) {
        if (sources == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.VolumeProjectionBuilder> each = sources.iterator();
        final List visitables = _visitables.get("sources");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.VolumeProjectionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSources instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.VolumeProjection> getSources() {
        return build(sources);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.VolumeProjection> buildSources() {
        return build(sources);
    }

    public io.fabric8.kubernetes.api.model.VolumeProjection buildSource(int index) {
        return this.sources.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.VolumeProjection buildFirstSource() {
        return this.sources.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.VolumeProjection buildLastSource() {
        return this.sources.get(sources.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.VolumeProjection buildMatchingSource(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeProjectionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.VolumeProjectionBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingSource(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeProjectionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.VolumeProjectionBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSources(java.util.List<io.fabric8.kubernetes.api.model.VolumeProjection> sources) {
        if (this.sources != null) { _visitables.get("sources").removeAll(this.sources);}
        if (sources != null) {this.sources = new java.util.ArrayList<io.fabric8.kubernetes.api.model.VolumeProjectionBuilder>(); for (io.fabric8.kubernetes.api.model.VolumeProjection item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
    }

    public A withSources(io.fabric8.kubernetes.api.model.VolumeProjection... sources) {
        if (this.sources != null) {this.sources.clear();}
        if (sources != null) {for (io.fabric8.kubernetes.api.model.VolumeProjection item :sources){ this.addToSources(item);}} return (A) this;
    }

    public java.lang.Boolean hasSources() {
        return sources != null && !sources.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent.SourcesNested<A> addNewSource() {
        return new io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluentImpl.SourcesNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent.SourcesNested<A> addNewSourceLike(io.fabric8.kubernetes.api.model.VolumeProjection item) {
        return new io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluentImpl.SourcesNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent.SourcesNested<A> setNewSourceLike(int index,io.fabric8.kubernetes.api.model.VolumeProjection item) {
        return new io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluentImpl.SourcesNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent.SourcesNested<A> editSource(int index) {
        if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
        return setNewSourceLike(index, buildSource(index));
    }

    public io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent.SourcesNested<A> editFirstSource() {
        if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
        return setNewSourceLike(0, buildSource(0));
    }

    public io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent.SourcesNested<A> editLastSource() {
        int index = sources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
        return setNewSourceLike(index, buildSource(index));
    }

    public io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent.SourcesNested<A> editMatchingSource(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeProjectionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<sources.size();i++) { 
        if (predicate.test(sources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
        return setNewSourceLike(index, buildSource(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProjectedVolumeSourceFluentImpl that = (ProjectedVolumeSourceFluentImpl) o;
        if (defaultMode != null ? !defaultMode.equals(that.defaultMode) :that.defaultMode != null) return false;
        if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(defaultMode,  sources,  super.hashCode());
    }

    public class SourcesNestedImpl<N> extends io.fabric8.kubernetes.api.model.VolumeProjectionFluentImpl<io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent.SourcesNested<N>> implements io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent.SourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.VolumeProjectionBuilder builder;
        private final int index;

            SourcesNestedImpl(int index,io.fabric8.kubernetes.api.model.VolumeProjection item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.VolumeProjectionBuilder(this, item);
                        
            }

            SourcesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.VolumeProjectionBuilder(this);
                        
            }

            public N and() {
                return (N) ProjectedVolumeSourceFluentImpl.this.setToSources(index,builder.build());
            }

            public N endSource() {
                return and();
            }
    }


}
