package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RBDVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.RBDVolumeSource,io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RBDVolumeSourceBuilder() {
        this(true);
    }

    public RBDVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new RBDVolumeSource(), validationEnabled);
    }

    public RBDVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public RBDVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RBDVolumeSource(), validationEnabled);
    }

    public RBDVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.RBDVolumeSource instance) {
        this(fluent, instance, true);
    }

    public RBDVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.RBDVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFsType(instance.getFsType()); 
        fluent.withImage(instance.getImage()); 
        fluent.withKeyring(instance.getKeyring()); 
        fluent.withMonitors(instance.getMonitors()); 
        fluent.withPool(instance.getPool()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        fluent.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public RBDVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDVolumeSource instance) {
        this(instance,true);
    }

    public RBDVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFsType(instance.getFsType()); 
        this.withImage(instance.getImage()); 
        this.withKeyring(instance.getKeyring()); 
        this.withMonitors(instance.getMonitors()); 
        this.withPool(instance.getPool()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.RBDVolumeSource build() {
        RBDVolumeSource buildable = new RBDVolumeSource(fluent.getFsType(),fluent.getImage(),fluent.getKeyring(),fluent.getMonitors(),fluent.getPool(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getUser());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RBDVolumeSourceBuilder that = (RBDVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
