/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ConfigMapProjection;
import io.fabric8.kubernetes.api.model.ConfigMapProjectionFluent;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import io.fabric8.kubernetes.api.model.KeyToPathFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ConfigMapProjectionFluentImpl<A extends ConfigMapProjectionFluent<A>>
extends BaseFluent<A>
implements ConfigMapProjectionFluent<A> {
    private List<KeyToPathBuilder> items = new ArrayList<KeyToPathBuilder>();
    private String name;
    private Boolean optional;

    public ConfigMapProjectionFluentImpl() {
    }

    public ConfigMapProjectionFluentImpl(ConfigMapProjection instance) {
        this.withItems(instance.getItems());
        this.withName(instance.getName());
        this.withOptional(instance.getOptional());
    }

    @Override
    public A addToItems(Integer index, KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList<KeyToPathBuilder>();
        }
        KeyToPathBuilder builder = new KeyToPathBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index.intValue() : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList<KeyToPathBuilder>();
        }
        KeyToPathBuilder builder = new KeyToPathBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(KeyToPath ... items) {
        if (this.items == null) {
            this.items = new ArrayList<KeyToPathBuilder>();
        }
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<KeyToPath> items) {
        if (this.items == null) {
            this.items = new ArrayList<KeyToPathBuilder>();
        }
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(KeyToPath ... items) {
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<KeyToPath> items) {
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<KeyToPathBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<KeyToPathBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            KeyToPathBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<KeyToPath> getItems() {
        return ConfigMapProjectionFluentImpl.build(this.items);
    }

    @Override
    public List<KeyToPath> buildItems() {
        return ConfigMapProjectionFluentImpl.build(this.items);
    }

    @Override
    public KeyToPath buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public KeyToPath buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public KeyToPath buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public KeyToPath buildMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        for (KeyToPathBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        for (KeyToPathBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<KeyToPath> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<KeyToPathBuilder>();
            for (KeyToPath item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(KeyToPath ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (KeyToPath item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public A addNewItem(String key, Integer mode, String path) {
        return this.addToItems(new KeyToPath(key, mode, path));
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> addNewItemLike(KeyToPath item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> setNewItemLike(Integer index, KeyToPath item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ConfigMapProjectionFluent.ItemsNested<A> editMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public A withOptional(Boolean optional) {
        this.optional = optional;
        return (A)this;
    }

    @Override
    public Boolean hasOptional() {
        return this.optional != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigMapProjectionFluentImpl that = (ConfigMapProjectionFluentImpl)o;
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.optional != null ? !this.optional.equals(that.optional) : that.optional != null);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.name, this.optional, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends KeyToPathFluentImpl<ConfigMapProjectionFluent.ItemsNested<N>>
    implements ConfigMapProjectionFluent.ItemsNested<N>,
    Nested<N> {
        KeyToPathBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, KeyToPath item) {
            this.index = index;
            this.builder = new KeyToPathBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new KeyToPathBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConfigMapProjectionFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

