package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterFluent<A extends ClusterFluent<A>> extends BaseFluent<A>{
  public ClusterFluent() {
  }
  
  public ClusterFluent(Cluster instance) {
    this.copyInstance(instance);
  }
  private String certificateAuthority;
  private String certificateAuthorityData;
  private Boolean disableCompression;
  private ArrayList<NamedExtensionBuilder> extensions = new ArrayList<NamedExtensionBuilder>();
  private Boolean insecureSkipTlsVerify;
  private String proxyUrl;
  private String server;
  private String tlsServerName;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Cluster instance) {
    instance = (instance != null ? instance : new Cluster());
    if (instance != null) {
          this.withCertificateAuthority(instance.getCertificateAuthority());
          this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
          this.withDisableCompression(instance.getDisableCompression());
          this.withExtensions(instance.getExtensions());
          this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
          this.withProxyUrl(instance.getProxyUrl());
          this.withServer(instance.getServer());
          this.withTlsServerName(instance.getTlsServerName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCertificateAuthority() {
    return this.certificateAuthority;
  }
  
  public A withCertificateAuthority(String certificateAuthority) {
    this.certificateAuthority = certificateAuthority;
    return (A) this;
  }
  
  public boolean hasCertificateAuthority() {
    return this.certificateAuthority != null;
  }
  
  public String getCertificateAuthorityData() {
    return this.certificateAuthorityData;
  }
  
  public A withCertificateAuthorityData(String certificateAuthorityData) {
    this.certificateAuthorityData = certificateAuthorityData;
    return (A) this;
  }
  
  public boolean hasCertificateAuthorityData() {
    return this.certificateAuthorityData != null;
  }
  
  public Boolean getDisableCompression() {
    return this.disableCompression;
  }
  
  public A withDisableCompression(Boolean disableCompression) {
    this.disableCompression = disableCompression;
    return (A) this;
  }
  
  public boolean hasDisableCompression() {
    return this.disableCompression != null;
  }
  
  public A addToExtensions(int index,NamedExtension item) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
    if (index < 0 || index >= extensions.size()) { _visitables.get("extensions").add(builder); extensions.add(builder); } else { _visitables.get("extensions").add(index, builder); extensions.add(index, builder);}
    return (A)this;
  }
  
  public A setToExtensions(int index,NamedExtension item) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
    if (index < 0 || index >= extensions.size()) { _visitables.get("extensions").add(builder); extensions.add(builder); } else { _visitables.get("extensions").set(index, builder); extensions.set(index, builder);}
    return (A)this;
  }
  
  public A addToExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  
  public A addAllToExtensions(Collection<NamedExtension> items) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  
  public A removeFromExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    if (this.extensions == null) return (A)this;
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder); this.extensions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromExtensions(Collection<NamedExtension> items) {
    if (this.extensions == null) return (A)this;
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder); this.extensions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
    if (extensions == null) return (A) this;
    final Iterator<NamedExtensionBuilder> each = extensions.iterator();
    final List visitables = _visitables.get("extensions");
    while (each.hasNext()) {
      NamedExtensionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NamedExtension> buildExtensions() {
    return this.extensions != null ? build(extensions) : null;
  }
  
  public NamedExtension buildExtension(int index) {
    return this.extensions.get(index).build();
  }
  
  public NamedExtension buildFirstExtension() {
    return this.extensions.get(0).build();
  }
  
  public NamedExtension buildLastExtension() {
    return this.extensions.get(extensions.size() - 1).build();
  }
  
  public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
      for (NamedExtensionBuilder item : extensions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
      for (NamedExtensionBuilder item : extensions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExtensions(List<NamedExtension> extensions) {
    if (this.extensions != null) {
      this._visitables.get("extensions").clear();
    }
    if (extensions != null) {
        this.extensions = new ArrayList();
        for (NamedExtension item : extensions) {
          this.addToExtensions(item);
        }
    } else {
      this.extensions = null;
    }
    return (A) this;
  }
  
  public A withExtensions(io.fabric8.kubernetes.api.model.NamedExtension... extensions) {
    if (this.extensions != null) {
        this.extensions.clear();
        _visitables.remove("extensions");
    }
    if (extensions != null) {
      for (NamedExtension item : extensions) {
        this.addToExtensions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExtensions() {
    return this.extensions != null && !this.extensions.isEmpty();
  }
  
  public ExtensionsNested<A> addNewExtension() {
    return new ExtensionsNested(-1, null);
  }
  
  public ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
    return new ExtensionsNested(-1, item);
  }
  
  public ExtensionsNested<A> setNewExtensionLike(int index,NamedExtension item) {
    return new ExtensionsNested(index, item);
  }
  
  public ExtensionsNested<A> editExtension(int index) {
    if (extensions.size() <= index) throw new RuntimeException("Can't edit extensions. Index exceeds size.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  
  public ExtensionsNested<A> editFirstExtension() {
    if (extensions.size() == 0) throw new RuntimeException("Can't edit first extensions. The list is empty.");
    return setNewExtensionLike(0, buildExtension(0));
  }
  
  public ExtensionsNested<A> editLastExtension() {
    int index = extensions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extensions. The list is empty.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  
  public ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extensions.size();i++) { 
    if (predicate.test(extensions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extensions. No match found.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  
  public Boolean getInsecureSkipTlsVerify() {
    return this.insecureSkipTlsVerify;
  }
  
  public A withInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify) {
    this.insecureSkipTlsVerify = insecureSkipTlsVerify;
    return (A) this;
  }
  
  public boolean hasInsecureSkipTlsVerify() {
    return this.insecureSkipTlsVerify != null;
  }
  
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl = proxyUrl;
    return (A) this;
  }
  
  public boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  
  public String getServer() {
    return this.server;
  }
  
  public A withServer(String server) {
    this.server = server;
    return (A) this;
  }
  
  public boolean hasServer() {
    return this.server != null;
  }
  
  public String getTlsServerName() {
    return this.tlsServerName;
  }
  
  public A withTlsServerName(String tlsServerName) {
    this.tlsServerName = tlsServerName;
    return (A) this;
  }
  
  public boolean hasTlsServerName() {
    return this.tlsServerName != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterFluent that = (ClusterFluent) o;
    if (!java.util.Objects.equals(certificateAuthority, that.certificateAuthority)) return false;
    if (!java.util.Objects.equals(certificateAuthorityData, that.certificateAuthorityData)) return false;
    if (!java.util.Objects.equals(disableCompression, that.disableCompression)) return false;
    if (!java.util.Objects.equals(extensions, that.extensions)) return false;
    if (!java.util.Objects.equals(insecureSkipTlsVerify, that.insecureSkipTlsVerify)) return false;
    if (!java.util.Objects.equals(proxyUrl, that.proxyUrl)) return false;
    if (!java.util.Objects.equals(server, that.server)) return false;
    if (!java.util.Objects.equals(tlsServerName, that.tlsServerName)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(certificateAuthority,  certificateAuthorityData,  disableCompression,  extensions,  insecureSkipTlsVerify,  proxyUrl,  server,  tlsServerName,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (certificateAuthority != null) { sb.append("certificateAuthority:"); sb.append(certificateAuthority + ","); }
    if (certificateAuthorityData != null) { sb.append("certificateAuthorityData:"); sb.append(certificateAuthorityData + ","); }
    if (disableCompression != null) { sb.append("disableCompression:"); sb.append(disableCompression + ","); }
    if (extensions != null && !extensions.isEmpty()) { sb.append("extensions:"); sb.append(extensions + ","); }
    if (insecureSkipTlsVerify != null) { sb.append("insecureSkipTlsVerify:"); sb.append(insecureSkipTlsVerify + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (server != null) { sb.append("server:"); sb.append(server + ","); }
    if (tlsServerName != null) { sb.append("tlsServerName:"); sb.append(tlsServerName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDisableCompression() {
    return withDisableCompression(true);
  }
  
  public A withInsecureSkipTlsVerify() {
    return withInsecureSkipTlsVerify(true);
  }
  public class ExtensionsNested<N> extends NamedExtensionFluent<ExtensionsNested<N>> implements Nested<N>{
    ExtensionsNested(int index,NamedExtension item) {
      this.index = index;
      this.builder = new NamedExtensionBuilder(this, item);
    }
    NamedExtensionBuilder builder;
    int index;
    
    public N and() {
      return (N) ClusterFluent.this.setToExtensions(index,builder.build());
    }
    
    public N endExtension() {
      return and();
    }
    
  
  }

}