package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConfigMapEnvSourceBuilder extends ConfigMapEnvSourceFluent<ConfigMapEnvSourceBuilder> implements VisitableBuilder<ConfigMapEnvSource,ConfigMapEnvSourceBuilder>{
  public ConfigMapEnvSourceBuilder() {
    this(new ConfigMapEnvSource());
  }
  
  public ConfigMapEnvSourceBuilder(ConfigMapEnvSourceFluent<?> fluent) {
    this(fluent, new ConfigMapEnvSource());
  }
  
  public ConfigMapEnvSourceBuilder(ConfigMapEnvSourceFluent<?> fluent,ConfigMapEnvSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConfigMapEnvSourceBuilder(ConfigMapEnvSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConfigMapEnvSourceFluent<?> fluent;
  
  public ConfigMapEnvSource build() {
    ConfigMapEnvSource buildable = new ConfigMapEnvSource(fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}