package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EndpointSubsetBuilder extends EndpointSubsetFluent<EndpointSubsetBuilder> implements VisitableBuilder<EndpointSubset,EndpointSubsetBuilder>{
  public EndpointSubsetBuilder() {
    this(new EndpointSubset());
  }
  
  public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent) {
    this(fluent, new EndpointSubset());
  }
  
  public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent,EndpointSubset instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EndpointSubsetBuilder(EndpointSubset instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EndpointSubsetFluent<?> fluent;
  
  public EndpointSubset build() {
    EndpointSubset buildable = new EndpointSubset(fluent.buildAddresses(),fluent.buildNotReadyAddresses(),fluent.buildPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}