package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WindowsSecurityContextOptionsBuilder extends WindowsSecurityContextOptionsFluent<WindowsSecurityContextOptionsBuilder> implements VisitableBuilder<WindowsSecurityContextOptions,WindowsSecurityContextOptionsBuilder>{
  public WindowsSecurityContextOptionsBuilder() {
    this(new WindowsSecurityContextOptions());
  }
  
  public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent) {
    this(fluent, new WindowsSecurityContextOptions());
  }
  
  public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent,WindowsSecurityContextOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WindowsSecurityContextOptionsFluent<?> fluent;
  
  public WindowsSecurityContextOptions build() {
    WindowsSecurityContextOptions buildable = new WindowsSecurityContextOptions(fluent.getGmsaCredentialSpec(),fluent.getGmsaCredentialSpecName(),fluent.getHostProcess(),fluent.getRunAsUserName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}