package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClaimSourceBuilder extends ClaimSourceFluent<ClaimSourceBuilder> implements VisitableBuilder<ClaimSource,ClaimSourceBuilder>{
  public ClaimSourceBuilder() {
    this(new ClaimSource());
  }
  
  public ClaimSourceBuilder(ClaimSourceFluent<?> fluent) {
    this(fluent, new ClaimSource());
  }
  
  public ClaimSourceBuilder(ClaimSourceFluent<?> fluent,ClaimSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClaimSourceBuilder(ClaimSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClaimSourceFluent<?> fluent;
  
  public ClaimSource build() {
    ClaimSource buildable = new ClaimSource(fluent.getResourceClaimName(),fluent.getResourceClaimTemplateName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}